/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.random;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class RandomUtils {
    public static <T> void shuffleRandomSample(List<T> source, Collection<T> out, int sampleSize, Random random) {
        Collections.shuffle(source, random);
        Iterator<T> it = source.iterator();
        while (out.size() < sampleSize && it.hasNext()) {
            out.add(it.next());
        }
    }

    public static <T> void shuffleRemoveRandomSample(List<T> source, Collection<T> out, int sampleSize, Random random) {
        Collections.shuffle(source, random);
        List<T> tmp = source.subList(0, sampleSize);
        out.addAll(tmp);
        tmp.clear();
    }

    public static <T> Set<T> randomSampleSet(Collection<T> source, int sampleSize, Random random) {
        ArrayList<T> src = new ArrayList<T>(source);
        HashSet result = new HashSet();
        RandomUtils.shuffleRandomSample(src, result, sampleSize, random);
        return result;
    }

    public static <T> Set<T> randomSampleSet(Collection<T> source, int sampleSize) {
        return RandomUtils.randomSampleSet(source, sampleSize, new Random());
    }

    public static <T> Set<T> shuffleRemoveRandomSampleSet(List<T> source, int sampleSize, Random random) {
        HashSet result = new HashSet();
        RandomUtils.shuffleRemoveRandomSample(source, result, sampleSize, random);
        return result;
    }

    public static <T> T randomItem(Collection<T> collection, Random random) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Collection must not be empty");
        }
        int index = random.nextInt(collection.size());
        return (T)Iterables.get(collection, (int)index);
    }

    public static <T> T randomItem(Iterable<T> iterable, Random random) {
        if (Iterables.isEmpty(iterable)) {
            throw new IllegalArgumentException("Iterable must not be empty");
        }
        int index = random.nextInt(Iterables.size(iterable));
        return (T)Iterables.get(iterable, (int)index);
    }
}

