/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    public static <S, T extends Iterable<S>> Iterable<S> safeGetFirst(Iterable<T> iterable) {
        Iterator<T> it = iterable.iterator();
        return it.hasNext() ? (Iterable)it.next() : Collections.emptySet();
    }

    public static <T> List<List<T>> chunk(Iterable<T> col, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> chunk = new ArrayList<T>();
        Iterator<T> it = col.iterator();
        while (it.hasNext()) {
            chunk.add(it.next());
            if (chunk.size() < batchSize && it.hasNext()) continue;
            result.add(chunk);
            if (!it.hasNext()) continue;
            chunk = new ArrayList();
        }
        return result;
    }

    public static <T> Set<T> asSet(Collection<T> c) {
        return c instanceof Set ? (Set<Object>)c : new HashSet<T>(c);
    }
}

