/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.apache;

import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.aksw.commons.collections.IClosableIterator;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.commons.collections.WindowedSorterIterator;
import org.aksw.commons.util.apache.ApacheLogDirectory;
import org.aksw.commons.util.apache.ApacheLogEntry;
import org.aksw.commons.util.apache.ApacheLogEntryDateComparator;
import org.aksw.commons.util.apache.ApacheLogEntryIterator;

public class ApacheLogRangeEntryIterator
extends SinglePrefetchIterator<ApacheLogEntry> {
    private Iterator<Map.Entry<Date, File>> itFile;
    private IClosableIterator<ApacheLogEntry> itEntry;
    private NavigableMap<Date, ApacheLogEntry> sortedBuffer = new TreeMap<Date, ApacheLogEntry>();
    int maxSortedBufferSize = 1000;
    private Date low;
    private Date high;
    private boolean lowInclusive;
    private boolean highInclusive;
    private Date sanityCheckMonotonictyDate = null;

    public ApacheLogRangeEntryIterator(Iterator<Map.Entry<Date, File>> itFile, Date low, boolean lowInclusive, Date high, boolean highInclusive) {
        this.itFile = itFile;
        this.low = low;
        this.high = high;
        this.lowInclusive = lowInclusive;
        this.highInclusive = highInclusive;
    }

    protected ApacheLogEntry prefetch() throws Exception {
        int d;
        ApacheLogEntry entry;
        while (this.sortedBuffer.size() < this.maxSortedBufferSize) {
            if (this.itEntry == null) {
                if (!this.itFile.hasNext()) break;
                this.itEntry = WindowedSorterIterator.wrap((Iterator)((Object)new ApacheLogEntryIterator(ApacheLogDirectory.open(this.itFile.next().getValue()), true)), (int)1000, (Comparator)new ApacheLogEntryDateComparator());
            }
            if (!this.itEntry.hasNext()) {
                this.itEntry = null;
                continue;
            }
            entry = (ApacheLogEntry)this.itEntry.next();
            if (this.low != null && ((d = entry.getDate().compareTo(this.low)) < 0 || d == 0 && !this.lowInclusive)) continue;
            this.sortedBuffer.put(entry.getDate(), entry);
        }
        if (!this.sortedBuffer.isEmpty()) {
            entry = this.sortedBuffer.pollFirstEntry().getValue();
            if (this.sanityCheckMonotonictyDate != null && this.sanityCheckMonotonictyDate.compareTo(entry.getDate()) > 0) {
                throw new RuntimeException("Dates are not monoton");
            }
            this.sanityCheckMonotonictyDate = entry.getDate();
            if (this.high != null && ((d = this.high.compareTo(entry.getDate())) < 0 || d == 0 && !this.highInclusive)) {
                return (ApacheLogEntry)this.finish();
            }
            return entry;
        }
        return (ApacheLogEntry)this.finish();
    }

    public void close() {
        if (this.itEntry != null) {
            this.itEntry.close();
        }
    }
}

