/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.apache;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.commons.util.apache.ApacheLogRequest;

public class ApacheLogEntry {
    private static final int NUM_FIELDS = 9;
    private static final Pattern logEntryPattern = Pattern.compile("^([^\\s]+) (\\S+) (\\S+) \\[([\\w:/]+\\s[+\\-]\\d{4})\\] \"(.+?)\" (\\d{3}) (\\d+) \"([^\"]+)\" \"([^\"]+)\"");
    private static final DateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    private String hostname;
    private Date date;
    private ApacheLogRequest request;
    private String response;
    private long byteCount;
    private String referer;
    private String userAgent;

    public String getHostname() {
        return this.hostname;
    }

    public Date getDate() {
        return this.date;
    }

    public ApacheLogRequest getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public String getReferer() {
        return this.referer;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    ApacheLogEntry(String logEntryLine) throws ParseException {
        Matcher matcher = logEntryPattern.matcher(logEntryLine);
        if (!matcher.matches()) {
            throw new ParseException("No matches found when parsing line: " + logEntryLine, 0);
        }
        if (9 != matcher.groupCount()) {
            throw new ParseException("Error parsing line: " + logEntryLine + " ; groupCount = " + matcher.groupCount(), 0);
        }
        this.hostname = matcher.group(1);
        this.date = dateFormat.parse(matcher.group(4));
        this.request = ApacheLogRequest.parse(matcher.group(5));
        this.response = matcher.group(6);
        this.byteCount = Long.parseLong(matcher.group(7));
        this.referer = "";
        if (!matcher.group(8).equals("-")) {
            this.referer = matcher.group(8);
        }
        this.userAgent = matcher.group(9);
    }

    public static ApacheLogEntry parse(String logEntryLine) throws ParseException {
        return new ApacheLogEntry(logEntryLine);
    }
}

