/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtils {
    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
    }

    public static void copyThenClose(InputStream in, OutputStream out) throws IOException {
        try {
            StreamUtils.copy(in, out, 1024);
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static String toString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.copyThenClose(in, out);
        return out.toString();
    }

    public static String toStringSafe(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StreamUtils.copyThenClose(in, out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }
}

