/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aksw.commons.util.reflect.ClassUtils;
import org.aksw.commons.util.reflect.InvocationSignature;
import org.aksw.commons.util.reflect.MultipleMethodsInvocationException;
import org.aksw.commons.util.reflect.NoMethodInvocationException;
import org.apache.commons.collections15.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMethod {
    private static LRUMap<InvocationSignature, Method> cache = new LRUMap(5000);

    public static <T, X> X invokeStatic(Class<T> clazz, String name, Object ... args) {
        Method m = MultiMethod.findMethodByArgs(clazz, name, args);
        return (X)ClassUtils.forceInvoke(null, m, args);
    }

    public static <X> X invoke(Object o, String name, Object ... args) {
        Method m = MultiMethod.findInvocationMethod(o.getClass(), name, args);
        return (X)ClassUtils.forceInvoke(o, m, args);
    }

    public static <T> Map<Method, Integer[]> findMethodCandidates(Collection<Method> candidates, Class<?> ... typeSignature) {
        HashMap<Method, Integer[]> bestMatches = new HashMap<Method, Integer[]>();
        for (Method m : candidates) {
            Integer[] d = ClassUtils.getDistance(typeSignature, m.getParameterTypes());
            if (d == null || Arrays.asList(d).contains(null)) continue;
            boolean canBeAdded = true;
            Iterator it = bestMatches.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int rel = ClassUtils.getRelation(d, (Integer[])entry.getValue());
                if (rel == -1) {
                    it.remove();
                    continue;
                }
                if (rel <= 0) continue;
                canBeAdded = false;
            }
            if (!canBeAdded) continue;
            bestMatches.put(m, d);
        }
        return bestMatches;
    }

    public static <T> Map<Method, Integer[]> findMethodCandidates(Class<T> clazz, String name, Class<?> ... typeSignature) {
        List<Method> methods = ClassUtils.getAllNonOverriddenMethods(clazz, name);
        Map<Method, Integer[]> result = MultiMethod.findMethodCandidates(methods, typeSignature);
        return result;
    }

    public static <T> Method findMethodByParamsCached(Class<T> clazz, String name, List<Class<?>> typeSignature) {
        InvocationSignature invocationSignature = new InvocationSignature(clazz, name, typeSignature);
        Method result = (Method)cache.get((Object)invocationSignature);
        if (result != null) {
            return result;
        }
        if (cache.containsKey((Object)invocationSignature)) {
            throw new RuntimeException("No method found for given classes");
        }
        result = MultiMethod.findMethodByParams(clazz, name, typeSignature.toArray(new Class[0]));
        cache.put((Object)invocationSignature, (Object)result);
        return result;
    }

    public static <T> Method findMethodByParams(Class<T> clazz, String name, Class<?> ... typeSignature) {
        Map<Method, Integer[]> bestMatches = MultiMethod.findMethodCandidates(clazz, name, typeSignature);
        if (bestMatches.size() == 0) {
            throw new NoMethodInvocationException(name, typeSignature);
        }
        if (bestMatches.size() > 1) {
            throw new MultipleMethodsInvocationException(name, null, bestMatches.keySet());
        }
        return bestMatches.entrySet().iterator().next().getKey();
    }

    @Deprecated
    public static <T> Method findInvocationMethod(Class<T> clazz, String name, Object ... args) {
        return MultiMethod.findMethodByArgs(clazz, name, args);
    }

    public static <T> Method findMethodByArgs(Class<T> clazz, String name, Object ... args) {
        List<Class<?>> typeSignature = ClassUtils.getTypeSignatureList(args);
        Method result = MultiMethod.findMethodByParamsCached(clazz, name, typeSignature);
        return result;
    }

    public static <T> Method findInvocationMethod(Class<T> clazz, Class<?> returnType, Class<?> ... args) {
        String name = "no name";
        Class<?>[] typeSignature = args;
        HashMap<Method, Integer[]> bestMatches = new HashMap<Method, Integer[]>();
        for (Method m : ClassUtils.getAllNonOverriddenMethods(clazz)) {
            Integer[] d;
            if (m.getParameterTypes().length < args.length && !m.isVarArgs() || (d = ClassUtils.getDistance(returnType, m.getReturnType(), typeSignature, m.getParameterTypes())) == null || Arrays.asList(d).contains(null)) continue;
            boolean canBeAdded = true;
            Iterator it = bestMatches.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int rel = ClassUtils.getRelation(d, (Integer[])entry.getValue());
                if (rel == -1) {
                    it.remove();
                    continue;
                }
                if (rel <= 0) continue;
                canBeAdded = false;
            }
            if (!canBeAdded) continue;
            bestMatches.put(m, d);
        }
        if (bestMatches.size() == 0) {
            throw new NoMethodInvocationException(name, args);
        }
        if (bestMatches.size() > 1) {
            throw new MultipleMethodsInvocationException(name, args, bestMatches.keySet());
        }
        return (Method)bestMatches.entrySet().iterator().next().getKey();
    }
}

