/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.commons.util.jdbc.ColumnsReference;
import org.aksw.commons.util.jdbc.PrimaryKey;
import org.aksw.commons.util.jdbc.Schema;
import org.aksw.commons.util.jdbc.SqlUtils;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inserter {
    private ColumnsReference target;
    private Schema schema;
    private List<Object> data = new ArrayList<Object>();

    public Inserter(ColumnsReference target, Schema schema) {
        this.target = target;
        this.schema = schema;
    }

    public void add(Object ... cells) {
        if (cells.length != this.target.getColumnNames().size()) {
            throw new RuntimeException("Provided cells (" + cells.length + ") does not match number of columns (" + this.target.getColumnNames().size() + "), Columns:" + this.target.getColumnNames() + " Data: " + cells);
        }
        for (Object cell : cells) {
            this.data.add(cell);
        }
    }

    public static String escapeSql(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof Number) {
            return "" + o;
        }
        return "'" + StringEscapeUtils.escapeSql((String)("" + o)) + "'";
    }

    public String composeCheckPart(List<Object> cells, int columnWidth, int[] idMap) {
        int numRows = this.data.size() / columnWidth;
        String idList = "";
        for (int i = 0; i < numRows; ++i) {
            if (i != 0) {
                idList = idList + ", ";
            }
            for (int j = 0; j < idMap.length; ++j) {
                int index = i * columnWidth + idMap[j];
                Object cell = this.data.get(index);
                if (j != 0) {
                    idList = idList + ", ";
                }
                idList = idList + Inserter.escapeSql("" + cell);
            }
        }
        return idList;
    }

    public Set<Integer> getBlacklistedRows(List<Object> cells, int columnWidth, int[] idMap, Set<Object> ids) {
        HashSet<Integer> result = new HashSet<Integer>();
        int numRows = this.data.size() / columnWidth;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < idMap.length; ++j) {
                int index = i * columnWidth + idMap[j];
                Object cell = this.data.get(index);
                if (!ids.contains(cell)) continue;
                result.add(i);
            }
        }
        return result;
    }

    public String composeInsertPart(List<Object> cells, int columnWidth, Set<Integer> blacklistedRows) {
        int numRows = this.data.size() / columnWidth;
        String idList = "";
        for (int i = 0; i < numRows; ++i) {
            if (blacklistedRows.contains(i)) continue;
            if (!idList.isEmpty()) {
                idList = idList + ", ";
            }
            idList = idList + "(";
            for (int j = 0; j < columnWidth; ++j) {
                int index = i * columnWidth + j;
                Object cell = this.data.get(index);
                if (j != 0) {
                    idList = idList + ", ";
                }
                idList = idList + Inserter.escapeSql("" + cell);
            }
            idList = idList + ")";
        }
        return idList;
    }

    public void flush(Connection conn) throws SQLException {
        String valueList;
        PrimaryKey targetPk = this.schema.getPrimaryKeys().get(this.target.getTableName());
        int columnWidth = this.target.getColumnNames().size();
        HashSet<Object> duplicateIds = new HashSet<Object>();
        Set<Integer> blacklistedRows = Collections.emptySet();
        if (targetPk != null) {
            List<String> idColumns = targetPk.getSource().getColumnNames();
            int d = idColumns.size();
            int[] idMap = new int[d];
            for (int i = 0; i < d; ++i) {
                String idColumn = idColumns.get(0);
                int j = this.target.getColumnNames().indexOf(idColumn);
                if (j < 0) {
                    throw new RuntimeException("Need all primary key columns: Inserted Columns " + this.target.getColumnNames() + ", Primary Key: " + targetPk.getSource().getColumnNames());
                }
                idMap[i] = j;
            }
            if (d != 1) {
                throw new RuntimeException("Only singe column primary keys supported - Sorry :(");
            }
            String idColumn = idColumns.get(0);
            String idList = this.composeCheckPart(this.data, columnWidth, idMap);
            if (!idList.isEmpty()) {
                String query = "SELECT " + idColumn + " FROM " + this.target.getTableName() + " WHERE " + idColumn + " IN (" + idList + ")";
                System.out.println("Dup check: " + query);
                List<Object> dupList = SqlUtils.executeList(conn, query, Object.class, new Object[0]);
                duplicateIds.addAll(dupList);
                System.out.println("Dups are: " + duplicateIds);
            }
            blacklistedRows = this.getBlacklistedRows(this.data, columnWidth, idMap, duplicateIds);
        }
        if (!(valueList = this.composeInsertPart(this.data, columnWidth, blacklistedRows)).isEmpty()) {
            String query = "INSERT INTO " + this.target.getTableName() + " VALUES " + valueList;
            System.out.println("Insert: " + query);
            SqlUtils.execute(conn, query, Void.class, new Object[0]);
        }
        this.data.clear();
    }
}

