/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.jdbc;

import com.google.common.base.Joiner;
import org.aksw.commons.util.jdbc.ColumnsReference;
import org.aksw.commons.util.jdbc.DatabaseObject;

public class ForeignKey
extends DatabaseObject {
    private ColumnsReference source;
    private ColumnsReference target;

    public ForeignKey(String name, ColumnsReference source, ColumnsReference target) {
        super(name);
        this.source = source;
        this.target = target;
    }

    public ColumnsReference getSource() {
        return this.source;
    }

    public ColumnsReference getTarget() {
        return this.target;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForeignKey other = (ForeignKey)obj;
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public String toString() {
        return "CONSTRAINT " + this.getName() + " FOREIGN KEY " + this.source.getTableName() + "(" + Joiner.on((String)", ").join(this.source.getColumnNames()) + ") REFERENCES " + this.target.getTableName() + "(" + Joiner.on((String)", ").join(this.target.getColumnNames()) + ")";
    }
}

