/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.compress;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class MetaBZip2CompressorInputStream
extends InputStream {
    private InputStream is;
    private BZip2CompressorInputStream current;
    private boolean isDone = false;

    public MetaBZip2CompressorInputStream(InputStream is) throws IOException {
        this.is = is;
        this.current = new BZip2CompressorInputStream(is);
    }

    void recreate() throws IOException {
        if (this.is.available() == 0) {
            this.isDone = true;
            return;
        }
        this.current = new BZip2CompressorInputStream(this.is);
    }

    public int read() throws IOException {
        int result = this.current.read();
        if (result == -1) {
            this.recreate();
            result = this.isDone ? result : this.current.read();
        }
        return result;
    }

    public int read(byte[] dest, int offs, int len) throws IOException {
        int result = this.current.read(dest, offs, len);
        if (result == -1) {
            this.recreate();
            result = this.isDone ? result : this.current.read(dest, offs, len);
        }
        return result;
    }

    public int read(byte[] dest) throws IOException {
        int result = this.current.read(dest);
        if (result == -1) {
            this.recreate();
            result = this.isDone ? result : this.current.read(dest);
        }
        return result;
    }
}

