/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prefixer {
    private Logger logger = LoggerFactory.getLogger(Prefixer.class);
    private final BidiMap<String, String> prefixToNamespace = new DualHashBidiMap();
    private final BidiMap<String, String> namespaceToPrefix = this.prefixToNamespace.inverseBidiMap();

    public Prefixer() {
    }

    public Prefixer(Map<String, String> prefixToNamespace, boolean appendPopularPrefixes) {
        this();
        if (appendPopularPrefixes) {
            this.prefixToNamespace.putAll(this.theMostPopulars());
        }
        this.prefixToNamespace.putAll(prefixToNamespace);
    }

    public void setPrefixToNamespace(Map<String, String> prefixToNamespace) {
        this.prefixToNamespace.clear();
        this.prefixToNamespace.putAll(prefixToNamespace);
    }

    public Map<String, String> theMostPopulars() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        m.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        m.put("owl", "http://www.w3.org/2002/07/owl#");
        m.put("dbpedia", "http://dbpedia.org/resource/");
        m.put("dbo", "http://dbpedia.org/ontology/");
        m.put("dbp", "http://dbpedia.org/property/");
        m.put("foaf", "http://xmlns.com/foaf/0.1/");
        m.put("skos", "http://www.w3.org/2004/02/skos/core#");
        m.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        m.put("dc", "http://purl.org/dc/elements/1.1/");
        m.put("geo", "http://www.w3.org/2003/01/geo/wgs84_pos#");
        return m;
    }

    public String toSparqlPrefix() {
        StringBuffer b = new StringBuffer();
        for (String key : this.prefixToNamespace.keySet()) {
            String value = (String)this.prefixToNamespace.get((Object)key);
            b.append("PREFIX " + key + ": <" + value + ">\n");
        }
        return b.toString();
    }

    public String nicen(String uri) {
        String name = this.stripNamespace(uri, true);
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("", (Throwable)e);
        }
        name = name.replaceAll("_", " ");
        return name;
    }

    public String stripNamespace(String uri) {
        return this.stripNamespace(uri, true);
    }

    public String stripNamespace(String uri, boolean useHeuristic) {
        for (String namespace : this.namespaceToPrefix.keySet()) {
            if (!uri.startsWith(namespace)) continue;
            return uri.replace(namespace, "");
        }
        return useHeuristic ? Prefixer.stripNamespaceHeuristic(uri) : uri;
    }

    public static String stripNamespaceHeuristic(String uri) {
        String[] separators;
        for (String sep : separators = new String[]{"#", "/"}) {
            int pos = uri.lastIndexOf(35);
            if (pos <= 0) continue;
            return uri.substring(pos);
        }
        return uri;
    }

    public String prefixUri(String uri) {
        for (String namespace : this.namespaceToPrefix.keySet()) {
            if (!uri.startsWith(namespace)) continue;
            return uri.replace(namespace, (String)this.namespaceToPrefix.get((Object)namespace) + ":");
        }
        return uri;
    }
}

