/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.util;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.commons.collections.IterableCollection;
import org.aksw.commons.util.Pair;
import org.aksw.commons.util.factory.Factory2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprUtils {
    public static Expr andifyBalanced(Expr ... exprs) {
        return ExprUtils.andifyBalanced(Arrays.asList(exprs));
    }

    public static Expr orifyBalanced(Expr ... exprs) {
        return ExprUtils.orifyBalanced(Arrays.asList(exprs));
    }

    public static List<String> extractNames(Collection<Var> vars) {
        ArrayList<String> result = new ArrayList<String>();
        for (Var var : vars) {
            result.add(var.getName());
        }
        return result;
    }

    public static Expr andifyBalanced(Iterable<Expr> exprs) {
        return ExprUtils.opifyBalanced(exprs, new Factory2<Expr>(){

            public Expr create(Expr a, Expr b) {
                return new E_LogicalAnd(a, b);
            }
        });
    }

    public static <T> T opifyBalanced(Iterable<T> exprs, Factory2<T> exprFactory) {
        if (!exprs.iterator().hasNext()) {
            return null;
        }
        ArrayList current = new ArrayList(IterableCollection.wrap(exprs));
        while (current.size() > 1) {
            ArrayList<Object> next = new ArrayList<Object>();
            Object left = null;
            for (Object expr : current) {
                if (left == null) {
                    left = expr;
                    continue;
                }
                Object newExpr = exprFactory.create(left, expr);
                next.add(newExpr);
                left = null;
            }
            if (left != null) {
                next.add(left);
            }
            current.clear();
            ArrayList tmp = current;
            current = next;
            ArrayList arrayList = tmp;
        }
        return (T)current.get(0);
    }

    public static Expr orifyBalanced(Iterable<Expr> exprs) {
        return ExprUtils.opifyBalanced(exprs, new Factory2<Expr>(){

            public Expr create(Expr a, Expr b) {
                return new E_LogicalOr(a, b);
            }
        });
    }

    public static Pair<Var, NodeValue> extractConstantConstraint(Expr expr) {
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            return ExprUtils.extractConstantConstraint(e.getArg1(), e.getArg2());
        }
        return null;
    }

    public static Pair<Var, NodeValue> extractConstantConstraint(Expr a, Expr b) {
        Pair<Var, NodeValue> result = ExprUtils.extractConstantConstraintDirected(a, b);
        if (result == null) {
            result = ExprUtils.extractConstantConstraintDirected(b, a);
        }
        return result;
    }

    public static Pair<Var, NodeValue> extractConstantConstraintDirected(Expr a, Expr b) {
        if (!a.isVariable() || !b.isConstant()) {
            return null;
        }
        Var var = a.getExprVar().asVar();
        NodeValue nodeValue = b.getConstant();
        return Pair.create((Object)var, (Object)nodeValue);
    }

    public static Collection<? extends Expr> getSubExpressions(Expr expr, boolean reflexive) {
        HashSet<Expr> result = new HashSet<Expr>();
        if (reflexive) {
            result.add(expr);
        }
        ExprUtils.getSubExpressions(expr, result);
        return result;
    }

    public static void getSubExpressions(Expr expr, Set<Expr> result) {
        if (expr.isFunction()) {
            ExprFunction f = (ExprFunction)expr;
            for (int i = 1; i <= f.numArgs(); ++i) {
                Expr arg = f.getArg(i);
                if (result.contains(arg)) continue;
                result.add(arg);
                ExprUtils.getSubExpressions(arg, result);
            }
        }
    }
}

