/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.http.HttpQuery;
import com.hp.hpl.jena.sparql.engine.http.Params;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.resultset.XMLInput;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.jena.DisconnectorThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ExtendedQueryEngineHTTP
implements QueryExecution {
    private static Logger log = LoggerFactory.getLogger(QueryEngineHTTP.class);
    public static final String QUERY_MIME_TYPE = "application/sparql-query";
    String queryString;
    String service;
    Context context = null;
    long timeOut = 0L;
    Params params = null;
    List<String> defaultGraphURIs = new ArrayList<String>();
    List<String> namedGraphURIs = new ArrayList<String>();
    private String user = null;
    private char[] password = null;
    private InputStream retainedConnection = null;

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public ExtendedQueryEngineHTTP(String serviceURI, Query query) {
        this(serviceURI, query.toString());
    }

    public ExtendedQueryEngineHTTP(String serviceURI, String queryString) {
        this.queryString = queryString;
        this.service = serviceURI;
        this.context = new Context(ARQ.getContext());
    }

    public void setFileManager(FileManager fm) {
        throw new UnsupportedOperationException("FileManagers do not apply to remote query execution");
    }

    public void setInitialBinding(QuerySolution binding) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries");
    }

    public void setInitialBindings(ResultSet table) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries");
    }

    public void setDefaultGraphURIs(List<String> defaultGraphURIs) {
        this.defaultGraphURIs = defaultGraphURIs;
    }

    public void setNamedGraphURIs(List<String> namedGraphURIs) {
        this.namedGraphURIs = namedGraphURIs;
    }

    public void addParam(String field, String value) {
        if (this.params == null) {
            this.params = new Params();
        }
        this.params.addParam(field, value);
    }

    public void addDefaultGraph(String defaultGraph) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList<String>();
        }
        this.defaultGraphURIs.add(defaultGraph);
    }

    public void addNamedGraph(String name) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        this.namedGraphURIs.add(name);
    }

    public void setBasicAuthentication(String user, char[] password) {
        this.user = user;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream doTimedExec(HttpQuery httpQuery) {
        InputStream in;
        DisconnectorThread stopTask = null;
        if (this.timeOut > 0L) {
            stopTask = new DisconnectorThread(httpQuery, this.timeOut);
            stopTask.start();
        }
        try {
            in = httpQuery.exec();
        }
        finally {
            if (stopTask != null) {
                stopTask.cancel();
            }
        }
        return in;
    }

    public ResultSet execSelect() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = this.doTimedExec(httpQuery);
        ResultSet rs = ResultSetFactory.fromXML((InputStream)in);
        this.retainedConnection = in;
        return rs;
    }

    public Model execConstruct() {
        return this.execConstruct(GraphFactory.makeJenaDefaultModel());
    }

    public Model execConstruct(Model model) {
        return this.execModel(model);
    }

    public Model execDescribe() {
        return this.execDescribe(GraphFactory.makeJenaDefaultModel());
    }

    public Model execDescribe(Model model) {
        return this.execModel(model);
    }

    private Model execModel(Model model) {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/rdf+xml");
        InputStream in = this.doTimedExec(httpQuery);
        model.read(in, null);
        return model;
    }

    public boolean execAsk() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = this.doTimedExec(httpQuery);
        boolean result = XMLInput.booleanFromXML((InputStream)in);
        try {
            in.close();
        }
        catch (IOException e) {
            log.warn("Failed to close connection", (Throwable)e);
        }
        return result;
    }

    public Context getContext() {
        return this.context;
    }

    public Query getQuery() {
        return null;
    }

    private HttpQuery makeHttpQuery() {
        HttpQuery httpQuery = new HttpQuery(this.service);
        httpQuery.addParam("query", this.queryString);
        for (String dft : this.defaultGraphURIs) {
            httpQuery.addParam("default-graph-uri", dft);
        }
        for (String name : this.namedGraphURIs) {
            httpQuery.addParam("named-graph-uri", name);
        }
        if (this.params != null) {
            httpQuery.merge(this.params);
        }
        httpQuery.setBasicAuthentication(this.user, this.password);
        return httpQuery;
    }

    public void abort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.retainedConnection != null) {
            try {
                this.retainedConnection.close();
            }
            catch (IOException e) {
                log.warn("Failed to close connection", (Throwable)e);
            }
            finally {
                this.retainedConnection = null;
            }
        }
    }

    public void setTimeout(long timeout, TimeUnit timeoutUnits) {
    }

    public void setTimeout(long timeout) {
    }

    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
    }

    public void setTimeout(long timeout1, long timeout2) {
    }

    public String toString() {
        HttpQuery httpQuery = this.makeHttpQuery();
        return "GET " + httpQuery.toString();
    }

    public Dataset getDataset() {
        return null;
    }
}

