/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena;

import com.hp.hpl.jena.sparql.engine.http.HttpQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DisconnectorThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DisconnectorThread.class);
    private HttpQuery connection;
    private long timeOut;
    private boolean canceled = false;

    public DisconnectorThread(HttpQuery connection, long timeOut) {
        this.connection = connection;
        this.timeOut = timeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DisconnectorThread disconnectorThread = this;
        synchronized (disconnectorThread) {
            long remaining;
            while (!this.canceled && this.connection.getConnection() == null) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException e) {}
            }
            long startTime = System.currentTimeMillis();
            while (!this.canceled && (remaining = this.timeOut - (System.currentTimeMillis() - startTime)) > 0L) {
                logger.trace("Forced disconnect in " + remaining + "ms");
                try {
                    this.wait(remaining);
                }
                catch (InterruptedException e) {}
            }
            if (!this.canceled && this.connection.getConnection() != null) {
                logger.warn("Disconnecting Http connection since a sparql query is taking too long");
                this.connection.getConnection().disconnect();
                this.canceled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        DisconnectorThread disconnectorThread = this;
        synchronized (disconnectorThread) {
            if (!this.canceled) {
                logger.trace("Disconnect cancelled");
            }
            this.canceled = true;
            this.notify();
        }
    }
}

