/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.multimaps;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.commons.collections.multimaps.ISetMultimap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiHashMultimap<K, V>
implements IBiSetMultimap<K, V> {
    private BiHashMultimap<V, K> inverse;
    private SetMultimap<K, V> forward;
    private SetMultimap<V, K> backward;

    public BiHashMultimap() {
        this.forward = HashMultimap.create();
        this.backward = HashMultimap.create();
        this.inverse = new BiHashMultimap<K, V>(this);
        this.inverse.inverse = this;
    }

    protected BiHashMultimap(BiHashMultimap<V, K> original) {
        this.inverse = original;
        this.forward = original.backward;
        this.backward = original.forward;
    }

    @Override
    public BiHashMultimap<V, K> getInverse() {
        return this.inverse;
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return this.forward.asMap();
    }

    public void remove(K key, V value) {
        this.forward.remove(key, value);
        this.backward.remove(value, key);
    }

    @Override
    public boolean put(K key, V value) {
        boolean result = this.forward.put(key, value);
        this.backward.put(value, key);
        return result;
    }

    @Override
    public Set<V> removeAll(Object key) {
        for (Object value : this.forward.get(key)) {
            this.backward.remove(value, key);
        }
        return this.forward.removeAll(key);
    }

    @Override
    public Set<V> get(Object key) {
        return this.forward.get(key);
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        return this.forward.containsEntry(key, value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.forward.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forward.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return this.forward.entries();
    }

    @Override
    public void putAll(K key, Collection<V> values) {
        for (V value : values) {
            this.put(key, value);
        }
    }

    @Override
    public void putAll(ISetMultimap<K, V> other) {
        for (Map.Entry<K, V> entry : other.entries()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return this.forward.toString();
    }

    @Override
    public int size() {
        return this.forward.size();
    }

    @Override
    public void clear() {
        this.forward.clear();
        this.backward.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiHashMultimap that = (BiHashMultimap)o;
        return !(this.forward != null ? !this.forward.equals(that.forward) : that.forward != null);
    }

    public int hashCode() {
        return this.forward != null ? this.forward.hashCode() : 0;
    }

    @Override
    public Set<K> keySet() {
        return this.forward.keySet();
    }

    @Override
    public Collection<K> keys() {
        return this.forward.keys();
    }
}

