/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.aksw.commons.collections.IClosable;
import org.aksw.commons.collections.IClosableIterator;
import org.aksw.commons.collections.SinglePrefetchIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowedSorterIterator<T>
extends SinglePrefetchIterator<T>
implements IClosableIterator<T> {
    private NavigableSet<T> buffer;
    private int maxBufferSize;
    private Iterator<T> it;

    public static <T> IClosableIterator<T> wrap(Iterator<T> it, int maxBufferSize, Comparator<T> comparator) {
        return new WindowedSorterIterator<T>(it, maxBufferSize, comparator);
    }

    public WindowedSorterIterator(Iterator<T> it, int maxBufferSize, Comparator<T> comparator) {
        this.buffer = new TreeSet<T>(comparator);
        this.it = it;
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    protected T prefetch() throws Exception {
        while (this.buffer.size() < this.maxBufferSize && this.it.hasNext()) {
            this.buffer.add(this.it.next());
        }
        return this.buffer.isEmpty() ? this.finish() : this.buffer.pollFirst();
    }

    @Override
    public void close() {
        if (this.it != null && this.it instanceof IClosable) {
            ((IClosable)((Object)this.it)).close();
        }
    }
}

