/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.iterators.TransformIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformCollection<I, O>
extends AbstractCollection<O> {
    private Collection<I> src;
    private Transformer<I, O> transformer;

    public TransformCollection(Collection<I> src, Transformer<I, O> transformer) {
        if (src == null) {
            src = Collections.emptySet();
        }
        this.src = src;
        this.transformer = transformer;
    }

    @Override
    public Iterator<O> iterator() {
        return new TransformIterator(this.src.iterator(), this.transformer);
    }

    @Override
    public int size() {
        return this.src.size();
    }

    public static <I, O> Collection<O> transformedView(Collection<I> src, Transformer<I, O> transformer) {
        return new TransformCollection<I, O>(src, transformer);
    }
}

