/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Set;
import org.aksw.commons.collections.Sample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleStats<T> {
    private static final DecimalFormat formatter = new DecimalFormat("0.######");
    private Sample<T> all;
    private Set<T> examples;
    private Sample<T> correctHits;
    private Sample<T> falseHits;

    private SampleStats(Sample<T> all, Set<T> examples) {
        this.all = all;
        this.examples = examples;
        this.correctHits = new Sample(Sets.intersection(all.getPositives(), examples), all.getNegatives() == null ? null : Sets.difference(all.getNegatives(), examples));
        this.falseHits = new Sample(Sets.difference(examples, all.getPositives()), Sets.difference(all.getPositives(), examples));
    }

    public static <T> SampleStats create(Sample<T> all, Set<T> examples) {
        return new SampleStats<T>(all, examples);
    }

    public static <T> SampleStats create(Sample<T> pool, Set<T> examples, Sample<T> all) {
        Sets.SetView deltaPositives = Sets.difference(all.getPositives(), pool.getPositives());
        Sets.SetView refinedExamples = Sets.difference(examples, (Set)deltaPositives);
        return new SampleStats<T>(pool, refinedExamples);
    }

    public static <T> SampleStats create(Set<T> allPositives, Set<T> allNegatives, Set<T> examples) {
        return new SampleStats<T>(new Sample<T>(allPositives, allNegatives), examples);
    }

    public Sample<T> getAll() {
        return this.all;
    }

    public Set<T> getExamples() {
        return this.examples;
    }

    public Sample<? extends T> getTrue() {
        return this.correctHits;
    }

    public Sample<? extends T> getFalse() {
        return this.falseHits;
    }

    public double getPrecision() {
        if (this.getExamples().isEmpty()) {
            return 0.0;
        }
        return (double)this.getTrue().getPositives().size() / (double)this.getExamples().size();
    }

    public double getRecall() {
        if (this.getAll().getPositives().isEmpty()) {
            return 0.0;
        }
        return (double)this.getTrue().getPositives().size() / (double)this.getAll().getPositives().size();
    }

    public double getFMeasure() {
        return SampleStats.fMeasure(this.getPrecision(), this.getRecall());
    }

    public static double fMeasure(double precision, double recall) {
        double denominator = precision + recall;
        return denominator == 0.0 ? 0.0 : 2.0 * precision * recall / denominator;
    }

    public String toString() {
        return "Precision/Recall/FMeasure = " + Joiner.on((String)"/").join((Object)formatter.format(this.getPrecision()), (Object)formatter.format(this.getRecall()), new Object[]{formatter.format(this.getFMeasure())}) + " --- " + "False Negatives " + SampleStats.toStringWithSize(this.getFalse().getNegatives());
    }

    public static String formatHumanReadable(SampleStats<?> stats) {
        DecimalFormat formatter = new DecimalFormat("0.##");
        return "Precision/Recall/FMeasure = " + Joiner.on((String)"/").join((Object)("" + formatter.format(stats.getPrecision() * 100.0) + "%"), (Object)("" + formatter.format(stats.getRecall() * 100.0) + "%"), new Object[]{"" + formatter.format(stats.getFMeasure() * 100.0) + "%"}) + " --- " + "False Negatives " + SampleStats.toStringWithSize(stats.getFalse().getNegatives());
    }

    public static String toStringWithSize(Collection<?> collection) {
        return collection == null ? "(null)" : "(" + collection.size() + ")" + collection;
    }
}

