/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrefetchIterator<T>
implements Iterator<T> {
    private Iterator<T> current = null;
    private boolean finished = false;

    protected abstract Iterator<T> prefetch() throws Exception;

    protected PrefetchIterator() {
    }

    private void preparePrefetch() {
        if (this.finished) {
            return;
        }
        this.current = null;
        try {
            do {
                this.current = this.prefetch();
            } while (this.current != null && !this.current.hasNext());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.current == null) {
            this.close();
            this.finished = true;
        }
    }

    private Iterator<T> getCurrent() {
        if (this.current == null || !this.current.hasNext()) {
            this.preparePrefetch();
        }
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.getCurrent() != null;
    }

    @Override
    public T next() {
        return this.getCurrent().next();
    }

    public void close() {
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

