/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtils {
    public static <K, V> boolean isCompatible(Map<K, V> a, Map<K, V> b) {
        return MapUtils.isPartiallyCompatible(a, b) && MapUtils.isPartiallyCompatible(b, a);
    }

    public static <K, V> boolean isPartiallyCompatible(Map<K, V> a, Map<K, V> b) {
        for (Map.Entry<K, V> entry : a.entrySet()) {
            K key = entry.getKey();
            V vA = entry.getValue();
            V vB = b.get(key);
            if (!(vA == null ? vB != null : !vA.equals(vB) && b.containsKey(key))) continue;
            return false;
        }
        return true;
    }

    public static <K, V> Multimap<V, K> reverse(Map<K, V> map) {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V> V getOrElse(Map<? extends K, ? extends V> map, K key, V elze) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return elze;
    }

    public static <K, V> Map<K, V> createChainMap(Map<K, ?> a, Map<?, V> b) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, ?> entry : a.entrySet()) {
            if (!b.containsKey(entry.getValue())) continue;
            result.put(entry.getKey(), b.get(entry.getValue()));
        }
        return result;
    }

    public static <K, V> V getOrCreate(Map<K, V> map, K key, Class<V> clazz, Object ... ctorArgs) {
        V result = map.get(key);
        if (result == null) {
            if (ctorArgs.length > 0) {
                throw new RuntimeException("Constructor arguments not supported yet");
            }
            try {
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            map.put(key, result);
        }
        return result;
    }
}

