/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartesianProductIterator<T>
implements Iterator<List<T>> {
    private List<? extends Iterable<? extends T>> collections;
    private List<Iterator<? extends T>> iterators;
    private List<T> current;
    private List<T> result;
    private List<T> resultView;
    private boolean hasNext = true;

    public CartesianProductIterator(T[] ... collections) {
        ArrayList<Iterable<T>> tmp = new ArrayList<Iterable<T>>(collections.length);
        for (T[] item : collections) {
            tmp.add(Arrays.asList(item));
        }
        this.collections = tmp;
        this.init();
    }

    public CartesianProductIterator(Iterable<? extends T> ... collections) {
        this.collections = Arrays.asList(collections);
        this.init();
    }

    public CartesianProductIterator(List<? extends Iterable<? extends T>> collections) {
        this.collections = collections;
        this.init();
    }

    private void init() {
        this.iterators = new ArrayList<Iterator<? extends T>>(this.collections.size());
        for (Iterable<T> iterable : this.collections) {
            this.iterators.add(iterable.iterator());
        }
        this.current = new ArrayList<T>(this.collections.size());
        this.result = new ArrayList<T>(this.collections.size());
        if (this.iterators.isEmpty()) {
            this.hasNext = false;
        }
        for (Iterator iterator : this.iterators) {
            if (!iterator.hasNext()) {
                this.hasNext = false;
                return;
            }
            Object value = iterator.next();
            this.current.add(value);
            this.result.add(null);
        }
        this.resultView = Collections.unmodifiableList(this.result);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public List<T> next() {
        int i;
        if (!this.hasNext) {
            return null;
        }
        for (i = 0; i < this.current.size(); ++i) {
            this.result.set(i, this.current.get(i));
        }
        for (i = this.iterators.size() - 1; i >= 0; --i) {
            Iterator<T> it = this.iterators.get(i);
            if (!it.hasNext()) {
                if (i == 0) {
                    this.hasNext = false;
                }
            } else {
                this.current.set(i, it.next());
                break;
            }
            it = this.collections.get(i).iterator();
            this.iterators.set(i, it);
            this.current.set(i, it.next());
        }
        return this.resultView;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Operation not supported");
    }
}

