/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheSet<K>
implements Set<K> {
    private static final long serialVersionUID = -4277098373746171836L;
    private Map<K, Integer> keyToTime = new HashMap<K, Integer>();
    private TreeMap<Integer, K> sortedTimes = new TreeMap();
    private int maxItemCount;
    private int currentTime;
    private boolean allowRenewal;

    public Integer getKeyTime(K key) {
        return this.keyToTime.get(key);
    }

    public CacheSet() {
        this.allowRenewal = true;
        this.setMaxItemCount(100);
    }

    public CacheSet(int maxItemCount, boolean allowRenewal) {
        this.allowRenewal = allowRenewal;
        this.setMaxItemCount(maxItemCount);
    }

    private Set<K> removeOutdated() {
        HashSet<K> removedKeys = new HashSet<K>();
        while (this.keyToTime.size() > this.maxItemCount) {
            removedKeys.add(this.removeOldest());
        }
        return removedKeys;
    }

    public Set<K> setMaxItemCount(int newMaxItemCount) {
        this.maxItemCount = newMaxItemCount;
        return this.removeOutdated();
    }

    private K removeOldest() {
        Map.Entry<Integer, K> removeItem = this.sortedTimes.pollFirstEntry();
        K result = removeItem.getValue();
        this.keyToTime.remove(result);
        this.sortedTimes.remove(removeItem.getKey());
        return result;
    }

    private K removeOldestChecked() {
        if (this.keyToTime.size() > this.maxItemCount) {
            return this.removeOldest();
        }
        return null;
    }

    private Integer initKeyTime(K key) {
        this.keyToTime.put(key, this.currentTime);
        this.sortedTimes.put(this.currentTime, (Integer)key);
        return this.currentTime++;
    }

    private void updateKeyTime(K key, Integer oldTime) {
        this.sortedTimes.remove(oldTime);
        this.initKeyTime(key);
    }

    public boolean renew(Object key) {
        Integer keyTime = this.keyToTime.get(key);
        if (keyTime == null) {
            return false;
        }
        this.updateKeyTime(key, keyTime);
        return true;
    }

    public K addAndGetRemoved(K key) {
        this.add(key);
        return this.removeOldestChecked();
    }

    @Override
    public boolean add(K key) {
        boolean result = this._add(key);
        this.removeOldestChecked();
        return result;
    }

    public boolean _add(K key) {
        Integer keyTime = this.keyToTime.get(key);
        if (keyTime == null) {
            this.initKeyTime(key);
        } else if (this.allowRenewal) {
            this.updateKeyTime(key, keyTime);
        }
        return keyTime == null;
    }

    @Override
    public boolean addAll(Collection<? extends K> arg0) {
        boolean result = false;
        for (K item : arg0) {
            result |= this.add(item);
        }
        return result;
    }

    @Override
    public void clear() {
        this.keyToTime.clear();
        this.sortedTimes.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.keyToTime.containsKey(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        boolean result = true;
        for (Object item : arg0) {
            result &= this.contains(item);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.keyToTime.isEmpty();
    }

    @Override
    public Iterator<K> iterator() {
        return this.keyToTime.keySet().iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        Integer time = this.keyToTime.get(arg0);
        if (time == null) {
            return false;
        }
        this.sortedTimes.remove(time);
        this.keyToTime.remove(arg0);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        boolean result = false;
        for (Object item : items) {
            result = result || this.remove(item);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public int size() {
        return this.keyToTime.size();
    }

    @Override
    public Object[] toArray() {
        return this.keyToTime.keySet().toArray();
    }

    @Override
    public <X> X[] toArray(X[] arg0) {
        return this.keyToTime.keySet().toArray(arg0);
    }

    @Override
    public int hashCode() {
        return this.keyToTime.keySet().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.keyToTime.keySet().equals(o);
    }

    public String toString() {
        return this.keyToTime.keySet().toString();
    }
}

