/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.sameas4j.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nnsoft.sameas4j.cache.Cache;
import org.nnsoft.sameas4j.cache.CacheKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InMemoryCache
implements Cache {
    private static final int CACHE_SIZE = 255;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CACHE_CAPACITY = (int)Math.ceil(340.0) + 1;
    private final Map<CacheKey, Object> data = new LinkedHashMap<CacheKey, Object>(CACHE_CAPACITY, 0.75f){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<CacheKey, Object> eldest) {
            return this.size() > 255;
        }
    };

    @Override
    public <T> T get(CacheKey cacheKey, Class<T> type) {
        if (cacheKey == null) {
            throw new IllegalArgumentException("Parameter 'cacheKey' must be not null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must be not null");
        }
        Object cached = this.data.get(cacheKey);
        if (cached != null) {
            if (!type.isInstance(cached)) {
                throw new IllegalArgumentException("Cached object for " + cacheKey + " is not of type " + type.getName());
            }
            return type.cast(cached);
        }
        return null;
    }

    @Override
    public <T> void put(CacheKey cacheKey, T cacheValue) {
        if (cacheKey == null) {
            throw new IllegalArgumentException("Parameter 'cacheKey' must be not null");
        }
        if (cacheValue == null) {
            throw new IllegalArgumentException("Parameter 'cacheValue' must be not null");
        }
        this.data.put(cacheKey, cacheValue);
    }
}

