/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.sameas4j.cache;

import java.io.Serializable;

public final class CacheKey
implements Serializable {
    private static final long serialVersionUID = 634054729365372230L;
    private final String service;
    private final long lastModified;

    public CacheKey(String service, long lastModified) {
        if (service == null) {
            throw new IllegalArgumentException("Parameter 'service' must not be null");
        }
        this.service = service;
        this.lastModified = lastModified;
    }

    public String getService() {
        return this.service;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
        result = 31 * result + this.service.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        if (this.lastModified != other.getLastModified()) {
            return false;
        }
        return !(this.service == null ? other.getService() != null : !this.service.equals(other.getService()));
    }

    public String toString() {
        return String.format("CacheKey (service=%s, lastModified=%s)", this.service, this.lastModified);
    }
}

