/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.sameas4j;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.BitSet;
import org.nnsoft.sameas4j.Equivalence;

abstract class AbstractEquivalenceDeserializer {
    private static final String URI = "uri";
    private static final String DUPLICATES = "duplicates";
    private static final String EXCEPTION_MESSAGE = "URI '%s' seems to be not well-formed";
    private static final String UTF_8_ENCODING = "UTF-8";
    private static final BitSet UNRESERVED_CHARS;
    private static final byte URL_ESCAPE_CHAR = 37;

    AbstractEquivalenceDeserializer() {
    }

    public static String urlEncode(String text) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int n : AbstractEquivalenceDeserializer.toUTF8Bytes(text)) {
            if (n < 0) {
                n = 256 + n;
            }
            if (UNRESERVED_CHARS.get(n)) {
                buffer.write(n);
                continue;
            }
            buffer.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(n >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(n & 0xF, 16));
            buffer.write(hex1);
            buffer.write(hex2);
        }
        return new String(buffer.toByteArray());
    }

    private static byte[] toUTF8Bytes(String text) throws Exception {
        return text.getBytes(UTF_8_ENCODING);
    }

    public Equivalence getEquivalence(JsonElement json) {
        URI uri;
        String uriString = json.getAsJsonObject().getAsJsonPrimitive(URI).getAsString();
        try {
            uri = new URI(AbstractEquivalenceDeserializer.urlEncode(uriString));
        }
        catch (Exception e) {
            throw new JsonParseException(String.format(EXCEPTION_MESSAGE, uriString));
        }
        Equivalence equivalence = new Equivalence(uri);
        JsonArray duplicates = json.getAsJsonObject().getAsJsonArray(DUPLICATES);
        for (int i = 0; i < duplicates.size(); ++i) {
            try {
                equivalence.addDuplicate(new URI(AbstractEquivalenceDeserializer.urlEncode(duplicates.get(i).getAsString())));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return equivalence;
    }

    public static void main(String[] args) throws Exception {
        System.err.println(AbstractEquivalenceDeserializer.urlEncode("http://it.bestshopping.com/prezzi/Rome.sku=9780751339031|.html"));
    }

    static {
        int b;
        UNRESERVED_CHARS = new BitSet(256);
        for (b = 65; b <= 90; b = (int)((byte)(b + 1))) {
            UNRESERVED_CHARS.set(b);
        }
        for (b = 97; b <= 122; b = (int)((byte)(b + 1))) {
            UNRESERVED_CHARS.set(b);
        }
        for (b = 48; b <= 57; b = (int)((byte)(b + 1))) {
            UNRESERVED_CHARS.set(b);
        }
        UNRESERVED_CHARS.set(36);
        UNRESERVED_CHARS.set(35);
        UNRESERVED_CHARS.set(38);
        UNRESERVED_CHARS.set(43);
        UNRESERVED_CHARS.set(44);
        UNRESERVED_CHARS.set(59);
        UNRESERVED_CHARS.set(61);
        UNRESERVED_CHARS.set(63);
        UNRESERVED_CHARS.set(64);
        UNRESERVED_CHARS.set(47);
        UNRESERVED_CHARS.set(58);
        UNRESERVED_CHARS.set(45);
        UNRESERVED_CHARS.set(46);
        UNRESERVED_CHARS.set(95);
        UNRESERVED_CHARS.set(126);
    }
}

