/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.functions.LinearRegression;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Debug;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MathematicalExpression;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PropertyPath;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.Summarizable;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;
import weka.filters.unsupervised.attribute.NumericCleaner;
import weka.filters.unsupervised.instance.Resample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridSearch
extends RandomizableSingleClassifierEnhancer
implements AdditionalMeasureProducer,
Summarizable {
    private static final long serialVersionUID = -3034773968581595348L;
    public static final int EVALUATION_CC = 0;
    public static final int EVALUATION_RMSE = 1;
    public static final int EVALUATION_RRSE = 2;
    public static final int EVALUATION_MAE = 3;
    public static final int EVALUATION_RAE = 4;
    public static final int EVALUATION_COMBINED = 5;
    public static final int EVALUATION_ACC = 6;
    public static final int EVALUATION_KAPPA = 7;
    public static final Tag[] TAGS_EVALUATION = new Tag[]{new Tag(0, "CC", "Correlation coefficient"), new Tag(1, "RMSE", "Root mean squared error"), new Tag(2, "RRSE", "Root relative squared error"), new Tag(3, "MAE", "Mean absolute error"), new Tag(4, "RAE", "Root absolute error"), new Tag(5, "COMB", "Combined = (1-abs(CC)) + RRSE + RAE"), new Tag(6, "ACC", "Accuracy"), new Tag(7, "KAP", "Kappa")};
    public static final int TRAVERSAL_BY_ROW = 0;
    public static final int TRAVERSAL_BY_COLUMN = 1;
    public static final Tag[] TAGS_TRAVERSAL = new Tag[]{new Tag(0, "row-wise", "row-wise"), new Tag(1, "column-wise", "column-wise")};
    public static final String PREFIX_CLASSIFIER = "classifier.";
    public static final String PREFIX_FILTER = "filter.";
    protected Filter m_Filter;
    protected Filter m_BestFilter;
    protected Classifier m_BestClassifier;
    protected PointDouble m_Values = null;
    protected int m_Evaluation = 0;
    protected String m_Y_Property = "classifier.ridge";
    protected double m_Y_Min = -10.0;
    protected double m_Y_Max = 5.0;
    protected double m_Y_Step = 1.0;
    protected double m_Y_Base = 10.0;
    protected String m_Y_Expression = "pow(BASE,I)";
    protected String m_X_Property = "filter.numComponents";
    protected double m_X_Min = 5.0;
    protected double m_X_Max = 20.0;
    protected double m_X_Step = 1.0;
    protected double m_X_Base = 10.0;
    protected String m_X_Expression = "I";
    protected boolean m_GridIsExtendable = false;
    protected int m_MaxGridExtensions = 3;
    protected int m_GridExtensionsPerformed = 0;
    protected double m_SampleSize = 100.0;
    protected int m_Traversal = 1;
    protected File m_LogFile = new File(System.getProperty("user.dir"));
    protected Grid m_Grid;
    protected Instances m_Data;
    protected PerformanceCache m_Cache;
    protected boolean m_UniformPerformance = false;

    public GridSearch() {
        this.m_Classifier = new LinearRegression();
        ((LinearRegression)this.m_Classifier).setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
        ((LinearRegression)this.m_Classifier).setEliminateColinearAttributes(false);
        this.m_Filter = new PLSFilter();
        PLSFilter filter = new PLSFilter();
        filter.setPreprocessing(new SelectedTag(2, PLSFilter.TAGS_PREPROCESSING));
        filter.setReplaceMissing(true);
        try {
            this.m_BestClassifier = Classifier.makeCopy(this.m_Classifier);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.m_BestFilter = Filter.makeCopy(filter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String globalInfo() {
        return "Performs a grid search of parameter pairs for the a classifier (Y-axis, default is LinearRegression with the \"Ridge\" parameter) and the PLSFilter (X-axis, \"# of Components\") and chooses the best pair found for the actual predicting.\n\nThe initial grid is worked on with 2-fold CV to determine the values of the parameter pairs for the selected type of evaluation (e.g., accuracy). The best point in the grid is then taken and a 10-fold CV is performed with the adjacent parameter pairs. If a better pair is found, then this will act as new center and another 10-fold CV will be performed (kind of hill-climbing). This process is repeated until no better pair is found or the best pair is on the border of the grid.\nIn case the best pair is on the border, one can let GridSearch automatically extend the grid and continue the search. Check out the properties 'gridIsExtendable' (option '-extend-grid') and 'maxGridExtensions' (option '-max-grid-extensions <num>').\n\nGridSearch can handle doubles, integers (values are just cast to int) and booleans (0 is false, otherwise true). float, char and long are supported as well.\n\nThe best filter/classifier setup can be accessed after the buildClassifier call via the getBestFilter/getBestClassifier methods.\nNote on the implementation: after the data has been passed through the filter, a default NumericCleaner filter is applied to the data in order to avoid numbers that are getting too small and might produce NaNs in other schemes.";
    }

    @Override
    protected String defaultClassifierString() {
        return LinearRegression.class.getName();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        String desc = "";
        for (int i = 0; i < TAGS_EVALUATION.length; ++i) {
            SelectedTag tag = new SelectedTag(TAGS_EVALUATION[i].getID(), TAGS_EVALUATION);
            desc = desc + "\t" + tag.getSelectedTag().getIDStr() + " = " + tag.getSelectedTag().getReadable() + "\n";
        }
        result.addElement(new Option("\tDetermines the parameter used for evaluation:\n" + desc + "\t(default: " + new SelectedTag(0, TAGS_EVALUATION) + ")", "E", 1, "-E " + Tag.toOptionList(TAGS_EVALUATION)));
        result.addElement(new Option("\tThe Y option to test (without leading dash).\n\t(default: classifier.ridge)", "y-property", 1, "-y-property <option>"));
        result.addElement(new Option("\tThe minimum for Y.\n\t(default: -10)", "y-min", 1, "-y-min <num>"));
        result.addElement(new Option("\tThe maximum for Y.\n\t(default: +5)", "y-max", 1, "-y-max <num>"));
        result.addElement(new Option("\tThe step size for Y.\n\t(default: 1)", "y-step", 1, "-y-step <num>"));
        result.addElement(new Option("\tThe base for Y.\n\t(default: 10)", "y-base", 1, "-y-base <num>"));
        result.addElement(new Option("\tThe expression for Y.\n\tAvailable parameters:\n\t\tBASE\n\t\tFROM\n\t\tTO\n\t\tSTEP\n\t\tI - the current iteration value\n\t\t(from 'FROM' to 'TO' with stepsize 'STEP')\n\t(default: 'pow(BASE,I)')", "y-expression", 1, "-y-expression <expr>"));
        result.addElement(new Option("\tThe filter to use (on X axis). Full classname of filter to include, \n\tfollowed by scheme options.\n\t(default: weka.filters.supervised.attribute.PLSFilter)", "filter", 1, "-filter <filter specification>"));
        result.addElement(new Option("\tThe X option to test (without leading dash).\n\t(default: filter.numComponents)", "x-property", 1, "-x-property <option>"));
        result.addElement(new Option("\tThe minimum for X.\n\t(default: +5)", "x-min", 1, "-x-min <num>"));
        result.addElement(new Option("\tThe maximum for X.\n\t(default: +20)", "x-max", 1, "-x-max <num>"));
        result.addElement(new Option("\tThe step size for X.\n\t(default: 1)", "x-step", 1, "-x-step <num>"));
        result.addElement(new Option("\tThe base for X.\n\t(default: 10)", "x-base", 1, "-x-base <num>"));
        result.addElement(new Option("\tThe expression for the X value.\n\tAvailable parameters:\n\t\tBASE\n\t\tMIN\n\t\tMAX\n\t\tSTEP\n\t\tI - the current iteration value\n\t\t(from 'FROM' to 'TO' with stepsize 'STEP')\n\t(default: 'pow(BASE,I)')", "x-expression", 1, "-x-expression <expr>"));
        result.addElement(new Option("\tWhether the grid can be extended.\n\t(default: no)", "extend-grid", 0, "-extend-grid"));
        result.addElement(new Option("\tThe maximum number of grid extensions (-1 is unlimited).\n\t(default: 3)", "max-grid-extensions", 1, "-max-grid-extensions <num>"));
        result.addElement(new Option("\tThe size (in percent) of the sample to search the inital grid with.\n\t(default: 100)", "sample-size", 1, "-sample-size <num>"));
        result.addElement(new Option("\tThe type of traversal for the grid.\n\t(default: " + new SelectedTag(1, TAGS_TRAVERSAL) + ")", "traversal", 1, "-traversal " + Tag.toOptionList(TAGS_TRAVERSAL)));
        result.addElement(new Option("\tThe log file to log the messages to.\n\t(default: none)", "log-file", 1, "-log-file <filename>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        if (this.getFilter() instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + " ('-filter'):"));
            en = ((OptionHandler)((Object)this.getFilter())).listOptions();
            while (en.hasMoreElements()) {
                result.addElement((Option)en.nextElement());
            }
        }
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-E");
        result.add("" + this.getEvaluation());
        result.add("-y-property");
        result.add("" + this.getYProperty());
        result.add("-y-min");
        result.add("" + this.getYMin());
        result.add("-y-max");
        result.add("" + this.getYMax());
        result.add("-y-step");
        result.add("" + this.getYStep());
        result.add("-y-base");
        result.add("" + this.getYBase());
        result.add("-y-expression");
        result.add("" + this.getYExpression());
        result.add("-filter");
        if (this.getFilter() instanceof OptionHandler) {
            result.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getFilter())).getOptions()));
        } else {
            result.add(this.getFilter().getClass().getName());
        }
        result.add("-x-property");
        result.add("" + this.getXProperty());
        result.add("-x-min");
        result.add("" + this.getXMin());
        result.add("-x-max");
        result.add("" + this.getXMax());
        result.add("-x-step");
        result.add("" + this.getXStep());
        result.add("-x-base");
        result.add("" + this.getXBase());
        result.add("-x-expression");
        result.add("" + this.getXExpression());
        if (this.getGridIsExtendable()) {
            result.add("-extend-grid");
            result.add("-max-grid-extensions");
            result.add("" + this.getMaxGridExtensions());
        }
        result.add("-sample-size");
        result.add("" + this.getSampleSizePercent());
        result.add("-traversal");
        result.add("" + this.getTraversal());
        result.add("-log-file");
        result.add("" + this.getLogFile());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('E', options);
        if (tmpStr.length() != 0) {
            this.setEvaluation(new SelectedTag(tmpStr, TAGS_EVALUATION));
        } else {
            this.setEvaluation(new SelectedTag(0, TAGS_EVALUATION));
        }
        tmpStr = Utils.getOption("y-property", options);
        if (tmpStr.length() != 0) {
            this.setYProperty(tmpStr);
        } else {
            this.setYProperty("classifier.ridge");
        }
        tmpStr = Utils.getOption("y-min", options);
        if (tmpStr.length() != 0) {
            this.setYMin(Double.parseDouble(tmpStr));
        } else {
            this.setYMin(-10.0);
        }
        tmpStr = Utils.getOption("y-max", options);
        if (tmpStr.length() != 0) {
            this.setYMax(Double.parseDouble(tmpStr));
        } else {
            this.setYMax(10.0);
        }
        tmpStr = Utils.getOption("y-step", options);
        if (tmpStr.length() != 0) {
            this.setYStep(Double.parseDouble(tmpStr));
        } else {
            this.setYStep(1.0);
        }
        tmpStr = Utils.getOption("y-base", options);
        if (tmpStr.length() != 0) {
            this.setYBase(Double.parseDouble(tmpStr));
        } else {
            this.setYBase(10.0);
        }
        tmpStr = Utils.getOption("y-expression", options);
        if (tmpStr.length() != 0) {
            this.setYExpression(tmpStr);
        } else {
            this.setYExpression("pow(BASE,I)");
        }
        tmpStr = Utils.getOption("filter", options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, tmpStr, tmpOptions));
        }
        if ((tmpStr = Utils.getOption("x-property", options)).length() != 0) {
            this.setXProperty(tmpStr);
        } else {
            this.setXProperty("filter.filters[0].kernel.gamma");
        }
        tmpStr = Utils.getOption("x-min", options);
        if (tmpStr.length() != 0) {
            this.setXMin(Double.parseDouble(tmpStr));
        } else {
            this.setXMin(-10.0);
        }
        tmpStr = Utils.getOption("x-max", options);
        if (tmpStr.length() != 0) {
            this.setXMax(Double.parseDouble(tmpStr));
        } else {
            this.setXMax(10.0);
        }
        tmpStr = Utils.getOption("x-step", options);
        if (tmpStr.length() != 0) {
            this.setXStep(Double.parseDouble(tmpStr));
        } else {
            this.setXStep(1.0);
        }
        tmpStr = Utils.getOption("x-base", options);
        if (tmpStr.length() != 0) {
            this.setXBase(Double.parseDouble(tmpStr));
        } else {
            this.setXBase(10.0);
        }
        tmpStr = Utils.getOption("x-expression", options);
        if (tmpStr.length() != 0) {
            this.setXExpression(tmpStr);
        } else {
            this.setXExpression("pow(BASE,I)");
        }
        this.setGridIsExtendable(Utils.getFlag("extend-grid", options));
        if (this.getGridIsExtendable()) {
            tmpStr = Utils.getOption("max-grid-extensions", options);
            if (tmpStr.length() != 0) {
                this.setMaxGridExtensions(Integer.parseInt(tmpStr));
            } else {
                this.setMaxGridExtensions(3);
            }
        }
        if ((tmpStr = Utils.getOption("sample-size", options)).length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(tmpStr));
        } else {
            this.setSampleSizePercent(100.0);
        }
        tmpStr = Utils.getOption("traversal", options);
        if (tmpStr.length() != 0) {
            this.setTraversal(new SelectedTag(tmpStr, TAGS_TRAVERSAL));
        } else {
            this.setTraversal(new SelectedTag(0, TAGS_TRAVERSAL));
        }
        tmpStr = Utils.getOption("log-file", options);
        if (tmpStr.length() != 0) {
            this.setLogFile(new File(tmpStr));
        } else {
            this.setLogFile(new File(System.getProperty("user.dir")));
        }
        super.setOptions(options);
    }

    @Override
    public void setClassifier(Classifier newClassifier) {
        boolean nominal;
        Capabilities cap = newClassifier.getCapabilities();
        boolean numeric = cap.handles(Capabilities.Capability.NUMERIC_CLASS) || cap.hasDependency(Capabilities.Capability.NUMERIC_CLASS);
        boolean bl = nominal = cap.handles(Capabilities.Capability.NOMINAL_CLASS) || cap.hasDependency(Capabilities.Capability.NOMINAL_CLASS) || cap.handles(Capabilities.Capability.BINARY_CLASS) || cap.hasDependency(Capabilities.Capability.BINARY_CLASS) || cap.handles(Capabilities.Capability.UNARY_CLASS) || cap.hasDependency(Capabilities.Capability.UNARY_CLASS);
        if (this.m_Evaluation == 0 && !numeric) {
            throw new IllegalArgumentException("Classifier needs to handle numeric class for chosen type of evaluation!");
        }
        if (!(this.m_Evaluation != 6 && this.m_Evaluation != 7 || nominal)) {
            throw new IllegalArgumentException("Classifier needs to handle nominal class for chosen type of evaluation!");
        }
        super.setClassifier(newClassifier);
        try {
            this.m_BestClassifier = Classifier.makeCopy(this.m_Classifier);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String filterTipText() {
        return "The filter to be used (only used for setup).";
    }

    public void setFilter(Filter value) {
        this.m_Filter = value;
        try {
            this.m_BestFilter = Filter.makeCopy(this.m_Filter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String evaluationTipText() {
        return "Sets the criterion for evaluating the classifier performance and choosing the best one.";
    }

    public void setEvaluation(SelectedTag value) {
        if (value.getTags() == TAGS_EVALUATION) {
            this.m_Evaluation = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getEvaluation() {
        return new SelectedTag(this.m_Evaluation, TAGS_EVALUATION);
    }

    public String YPropertyTipText() {
        return "The Y property to test (normally the classifier).";
    }

    public String getYProperty() {
        return this.m_Y_Property;
    }

    public void setYProperty(String value) {
        this.m_Y_Property = value;
    }

    public String YMinTipText() {
        return "The minimum of Y (normally the classifier).";
    }

    public double getYMin() {
        return this.m_Y_Min;
    }

    public void setYMin(double value) {
        this.m_Y_Min = value;
    }

    public String YMaxTipText() {
        return "The maximum of Y.";
    }

    public double getYMax() {
        return this.m_Y_Max;
    }

    public void setYMax(double value) {
        this.m_Y_Max = value;
    }

    public String YStepTipText() {
        return "The step size of Y.";
    }

    public double getYStep() {
        return this.m_Y_Step;
    }

    public void setYStep(double value) {
        this.m_Y_Step = value;
    }

    public String YBaseTipText() {
        return "The base of Y.";
    }

    public double getYBase() {
        return this.m_Y_Base;
    }

    public void setYBase(double value) {
        this.m_Y_Base = value;
    }

    public String YExpressionTipText() {
        return "The expression for the Y value (parameters: BASE, FROM, TO, STEP, I).";
    }

    public String getYExpression() {
        return this.m_Y_Expression;
    }

    public void setYExpression(String value) {
        this.m_Y_Expression = value;
    }

    public String XPropertyTipText() {
        return "The X property to test (normally the filter).";
    }

    public String getXProperty() {
        return this.m_X_Property;
    }

    public void setXProperty(String value) {
        this.m_X_Property = value;
    }

    public String XMinTipText() {
        return "The minimum of X.";
    }

    public double getXMin() {
        return this.m_X_Min;
    }

    public void setXMin(double value) {
        this.m_X_Min = value;
    }

    public String XMaxTipText() {
        return "The maximum of X.";
    }

    public double getXMax() {
        return this.m_X_Max;
    }

    public void setXMax(double value) {
        this.m_X_Max = value;
    }

    public String XStepTipText() {
        return "The step size of X.";
    }

    public double getXStep() {
        return this.m_X_Step;
    }

    public void setXStep(double value) {
        this.m_X_Step = value;
    }

    public String XBaseTipText() {
        return "The base of X.";
    }

    public double getXBase() {
        return this.m_X_Base;
    }

    public void setXBase(double value) {
        this.m_X_Base = value;
    }

    public String XExpressionTipText() {
        return "The expression for the X value (parameters: BASE, FROM, TO, STEP, I).";
    }

    public String getXExpression() {
        return this.m_X_Expression;
    }

    public void setXExpression(String value) {
        this.m_X_Expression = value;
    }

    public String gridIsExtendableTipText() {
        return "Whether the grid can be extended.";
    }

    public boolean getGridIsExtendable() {
        return this.m_GridIsExtendable;
    }

    public void setGridIsExtendable(boolean value) {
        this.m_GridIsExtendable = value;
    }

    public String maxGridExtensionsTipText() {
        return "The maximum number of grid extensions, -1 for unlimited.";
    }

    public int getMaxGridExtensions() {
        return this.m_MaxGridExtensions;
    }

    public void setMaxGridExtensions(int value) {
        this.m_MaxGridExtensions = value;
    }

    public String sampleSizePercentTipText() {
        return "The sample size (in percent) to use in the initial grid search.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSize;
    }

    public void setSampleSizePercent(double value) {
        this.m_SampleSize = value;
    }

    public String traversalTipText() {
        return "Sets type of traversal of the grid, either by rows or columns.";
    }

    public void setTraversal(SelectedTag value) {
        if (value.getTags() == TAGS_TRAVERSAL) {
            this.m_Traversal = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getTraversal() {
        return new SelectedTag(this.m_Traversal, TAGS_TRAVERSAL);
    }

    public String logFileTipText() {
        return "The log file to log the messages to.";
    }

    public File getLogFile() {
        return this.m_LogFile;
    }

    public void setLogFile(File value) {
        this.m_LogFile = value;
    }

    public Filter getBestFilter() {
        return this.m_BestFilter;
    }

    public Classifier getBestClassifier() {
        return this.m_BestClassifier;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> result = new Vector<String>();
        result.add("measureX");
        result.add("measureY");
        result.add("measureGridExtensionsPerformed");
        return result.elements();
    }

    @Override
    public double getMeasure(String measureName) {
        if (measureName.equalsIgnoreCase("measureX")) {
            return this.evaluate(this.getValues().getX(), true);
        }
        if (measureName.equalsIgnoreCase("measureY")) {
            return this.evaluate(this.getValues().getY(), false);
        }
        if (measureName.equalsIgnoreCase("measureGridExtensionsPerformed")) {
            return this.getGridExtensionsPerformed();
        }
        throw new IllegalArgumentException("Measure '" + measureName + "' not supported!");
    }

    public PointDouble getValues() {
        return this.m_Values;
    }

    public int getGridExtensionsPerformed() {
        return this.m_GridExtensionsPerformed;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getFilter() == null ? super.getCapabilities() : this.getFilter().getCapabilities();
        Capabilities classes = result.getClassCapabilities();
        Iterator iter = classes.capabilities();
        while (iter.hasNext()) {
            Capabilities.Capability capab = (Capabilities.Capability)((Object)iter.next());
            if (capab == Capabilities.Capability.BINARY_CLASS || capab == Capabilities.Capability.NOMINAL_CLASS || capab == Capabilities.Capability.NUMERIC_CLASS || capab == Capabilities.Capability.DATE_CLASS) continue;
            result.disable(capab);
        }
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        if (result.getMinimumNumberInstances() < 1) {
            result.setMinimumNumberInstances(1);
        }
        result.setOwner(this);
        return result;
    }

    protected void log(String message) {
        this.log(message, false);
    }

    protected void log(String message, boolean onlyLog) {
        if (this.getDebug() && !onlyLog) {
            System.out.println(message);
        }
        if (!this.getLogFile().isDirectory()) {
            Debug.writeToFile(this.getLogFile().getAbsolutePath(), message, true);
        }
    }

    protected String[] updateOption(String[] options, String option, String value) throws Exception {
        Utils.getOption(option, options);
        Vector<String> tmpOptions = new Vector<String>();
        tmpOptions.add("-" + option);
        tmpOptions.add("" + value);
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() == 0) continue;
            tmpOptions.add(options[i]);
        }
        String[] result = tmpOptions.toArray(new String[tmpOptions.size()]);
        return result;
    }

    protected double evaluate(double value, boolean isX) {
        double result;
        double step;
        double max;
        double min;
        double base;
        String expr;
        if (isX) {
            expr = this.getXExpression();
            base = this.getXBase();
            min = this.getXMin();
            max = this.getXMax();
            step = this.getXStep();
        } else {
            expr = this.getYExpression();
            base = this.getYBase();
            min = this.getYMin();
            max = this.getYMax();
            step = this.getYStep();
        }
        try {
            HashMap<String, Double> symbols = new HashMap<String, Double>();
            symbols.put("BASE", new Double(base));
            symbols.put("FROM", new Double(min));
            symbols.put("TO", new Double(max));
            symbols.put("STEP", new Double(step));
            symbols.put("I", new Double(value));
            result = MathematicalExpression.evaluate(expr, symbols);
        }
        catch (Exception e) {
            result = Double.NaN;
        }
        return result;
    }

    protected Object setValue(Object o, String path, double value) throws Exception {
        PropertyDescriptor desc = PropertyPath.getPropertyDescriptor(o, path);
        Class<?> c = desc.getPropertyType();
        if (c == Float.class || c == Float.TYPE) {
            PropertyPath.setValue(o, path, (Object)new Float((float)value));
        } else if (c == Double.class || c == Double.TYPE) {
            PropertyPath.setValue(o, path, (Object)new Double(value));
        } else if (c == Character.class || c == Character.TYPE) {
            PropertyPath.setValue(o, path, (Object)new Integer((char)value));
        } else if (c == Integer.class || c == Integer.TYPE) {
            PropertyPath.setValue(o, path, (Object)new Integer((int)value));
        } else if (c == Long.class || c == Long.TYPE) {
            PropertyPath.setValue(o, path, (Object)new Long((long)value));
        } else if (c == Boolean.class || c == Boolean.TYPE) {
            PropertyPath.setValue(o, path, (Object)(value == 0.0 ? new Boolean(false) : new Boolean(true)));
        } else {
            throw new Exception("Could neither set double nor integer nor boolean value for '" + path + "'!");
        }
        return o;
    }

    protected Object setup(Object original, double valueX, double valueY) throws Exception {
        Object result = new SerializedObject(original).getObject();
        if (original instanceof Classifier) {
            if (this.getXProperty().startsWith(PREFIX_CLASSIFIER)) {
                this.setValue(result, this.getXProperty().substring(PREFIX_CLASSIFIER.length()), valueX);
            }
            if (this.getYProperty().startsWith(PREFIX_CLASSIFIER)) {
                this.setValue(result, this.getYProperty().substring(PREFIX_CLASSIFIER.length()), valueY);
            }
        } else if (original instanceof Filter) {
            if (this.getXProperty().startsWith(PREFIX_FILTER)) {
                this.setValue(result, this.getXProperty().substring(PREFIX_FILTER.length()), valueX);
            }
            if (this.getYProperty().startsWith(PREFIX_FILTER)) {
                this.setValue(result, this.getYProperty().substring(PREFIX_FILTER.length()), valueY);
            }
        } else {
            throw new IllegalArgumentException("Object must be either classifier or filter!");
        }
        return result;
    }

    protected String logPerformances(Grid grid, Vector<Performance> performances, Tag type) {
        StringBuffer result = new StringBuffer(type.getReadable() + ":\n");
        PerformanceTable table = new PerformanceTable(grid, performances, type.getID());
        result.append(table.toString() + "\n");
        result.append("\n");
        result.append(table.toGnuplot() + "\n");
        result.append("\n");
        return result.toString();
    }

    protected void logPerformances(Grid grid, Vector performances) {
        for (int i = 0; i < TAGS_EVALUATION.length; ++i) {
            this.log("\n" + this.logPerformances(grid, performances, TAGS_EVALUATION[i]), true);
        }
    }

    protected PointDouble determineBestInGrid(Grid grid, Instances inst, int cv) throws Exception {
        int i;
        Vector<Performance> performances = new Vector<Performance>();
        this.log("Determining best pair with " + cv + "-fold CV in Grid:\n" + grid + "\n");
        int size = this.m_Traversal == 1 ? grid.width() : grid.height();
        boolean allCached = true;
        for (i = 0; i < size; ++i) {
            Enumeration<PointDouble> enm = this.m_Traversal == 1 ? grid.column(i) : grid.row(i);
            Filter filter = null;
            Instances data = null;
            while (enm.hasMoreElements()) {
                PointDouble values = enm.nextElement();
                boolean cached = this.m_Cache.isCached(cv, values);
                if (cached) {
                    performances.add(this.m_Cache.get(cv, values));
                } else {
                    allCached = false;
                    double x = this.evaluate(values.getX(), true);
                    double y = this.evaluate(values.getY(), false);
                    if (filter == null) {
                        filter = (Filter)this.setup(this.getFilter(), x, y);
                        filter.setInputFormat(inst);
                        data = Filter.useFilter(inst, filter);
                        NumericCleaner cleaner = new NumericCleaner();
                        ((Filter)cleaner).setInputFormat(data);
                        data = Filter.useFilter(data, cleaner);
                    }
                    Classifier classifier = (Classifier)this.setup(this.getClassifier(), x, y);
                    Evaluation eval = new Evaluation(data);
                    eval.crossValidateModel(classifier, data, cv, new Random(this.getSeed()), new Object[0]);
                    performances.add(new Performance(values, eval));
                    this.m_Cache.add(cv, new Performance(values, eval));
                }
                this.log("" + performances.get(performances.size() - 1) + ": cached=" + cached);
            }
        }
        if (allCached) {
            this.log("All points were already cached - abnormal state!");
            throw new IllegalStateException("All points were already cached - abnormal state!");
        }
        Collections.sort(performances, new PerformanceComparator(this.m_Evaluation));
        PointDouble result = ((Performance)performances.get(performances.size() - 1)).getValues();
        this.m_UniformPerformance = true;
        Performance p1 = (Performance)performances.get(0);
        for (i = 1; i < performances.size(); ++i) {
            Performance p2 = (Performance)performances.get(i);
            if (p2.getPerformance(this.m_Evaluation) == p1.getPerformance(this.m_Evaluation)) continue;
            this.m_UniformPerformance = false;
            break;
        }
        if (this.m_UniformPerformance) {
            this.log("All performances are the same!");
        }
        this.logPerformances(grid, performances);
        this.log("\nBest performance:\n" + performances.get(performances.size() - 1));
        return result;
    }

    protected PointDouble findBest() throws Exception {
        Instances sample;
        this.log("Step 1:\n");
        if (this.getSampleSizePercent() == 100.0) {
            sample = this.m_Data;
        } else {
            this.log("Generating sample (" + this.getSampleSizePercent() + "%)");
            Resample resample = new Resample();
            resample.setRandomSeed(this.getSeed());
            resample.setSampleSizePercent(this.getSampleSizePercent());
            resample.setInputFormat(this.m_Data);
            sample = Filter.useFilter(this.m_Data, resample);
        }
        boolean finished = false;
        int iteration = 0;
        this.m_GridExtensionsPerformed = 0;
        this.m_UniformPerformance = false;
        this.log("\n=== Initial grid - Start ===");
        PointDouble result = this.determineBestInGrid(this.m_Grid, sample, 2);
        this.log("\nResult of Step 1: " + result + "\n");
        this.log("=== Initial grid - End ===\n");
        finished = this.m_UniformPerformance;
        if (!finished) {
            do {
                ++iteration;
                PointDouble resultOld = (PointDouble)result.clone();
                PointInt center = this.m_Grid.getLocation(result);
                if (this.m_Grid.isOnBorder(center)) {
                    this.log("Center is on border of grid.");
                    if (this.getGridIsExtendable()) {
                        if (this.m_GridExtensionsPerformed == this.getMaxGridExtensions()) {
                            this.log("Maximum number of extensions reached!\n");
                            finished = true;
                        } else {
                            ++this.m_GridExtensionsPerformed;
                            this.m_Grid = this.m_Grid.extend(result);
                            center = this.m_Grid.getLocation(result);
                            this.log("Extending grid (" + this.m_GridExtensionsPerformed + "/" + this.getMaxGridExtensions() + "):\n" + this.m_Grid + "\n");
                        }
                    } else {
                        finished = true;
                    }
                }
                if (finished) continue;
                Grid neighborGrid = this.m_Grid.subgrid((int)center.getY() + 1, (int)center.getX() - 1, (int)center.getY() - 1, (int)center.getX() + 1);
                result = this.determineBestInGrid(neighborGrid, sample, 10);
                this.log("\nResult of Step 2/Iteration " + iteration + ":\n" + result);
                finished = this.m_UniformPerformance;
                if (!result.equals(resultOld)) continue;
                finished = true;
                this.log("\nNo better point found.");
            } while (!finished);
        }
        this.log("\nFinal result: " + result);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_Data = new Instances(data);
        this.m_Data.deleteWithMissingClass();
        this.m_Cache = new PerformanceCache();
        String strX = this.getXProperty().startsWith(PREFIX_FILTER) ? this.m_Filter.getClass().getName() : this.m_Classifier.getClass().getName();
        String strY = this.getYProperty().startsWith(PREFIX_CLASSIFIER) ? this.m_Classifier.getClass().getName() : this.m_Filter.getClass().getName();
        this.m_Grid = new Grid(this.getXMin(), this.getXMax(), this.getXStep(), strX + ", property " + this.getXProperty() + ", expr. " + this.getXExpression() + ", base " + this.getXBase(), this.getYMin(), this.getYMax(), this.getYStep(), strY + ", property " + this.getYProperty() + ", expr. " + this.getYExpression() + ", base " + this.getYBase());
        this.log("\n" + this.getClass().getName() + "\n" + this.getClass().getName().replaceAll(".", "=") + "\n" + "Options: " + Utils.joinOptions(this.getOptions()) + "\n");
        this.m_Values = this.findBest();
        double x = this.evaluate(this.m_Values.getX(), true);
        double y = this.evaluate(this.m_Values.getY(), false);
        this.m_BestFilter = (Filter)this.setup(this.getFilter(), x, y);
        this.m_BestClassifier = (Classifier)this.setup(this.getClassifier(), x, y);
        this.m_Filter = (Filter)this.setup(this.getFilter(), x, y);
        this.m_Filter.setInputFormat(this.m_Data);
        Instances transformed = Filter.useFilter(this.m_Data, this.m_Filter);
        this.m_Classifier = (Classifier)this.setup(this.getClassifier(), x, y);
        this.m_Classifier.buildClassifier(transformed);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_Filter.input(instance);
        this.m_Filter.batchFinished();
        Instance transformed = this.m_Filter.output();
        return this.m_Classifier.distributionForInstance(transformed);
    }

    public String toString() {
        String result = "";
        if (this.m_Values == null) {
            result = "No search performed yet.";
        } else {
            result = this.getClass().getName() + ":\n" + "Filter: " + this.getFilter().getClass().getName() + (this.getFilter() instanceof OptionHandler ? " " + Utils.joinOptions(((OptionHandler)((Object)this.getFilter())).getOptions()) : "") + "\n" + "Classifier: " + this.getClassifier().getClass().getName() + " " + Utils.joinOptions(this.getClassifier().getOptions()) + "\n\n" + "X property: " + this.getXProperty() + "\n" + "Y property: " + this.getYProperty() + "\n\n" + "Evaluation: " + this.getEvaluation().getSelectedTag().getReadable() + "\n" + "Coordinates: " + this.getValues() + "\n";
            if (this.getGridIsExtendable()) {
                result = result + "Grid-Extensions: " + this.getGridExtensionsPerformed() + "\n";
            }
            result = result + "Values: " + this.evaluate(this.getValues().getX(), true) + " (X coordinate)" + ", " + this.evaluate(this.getValues().getY(), false) + " (Y coordinate)" + "\n\n" + this.m_Classifier.toString();
        }
        return result;
    }

    @Override
    public String toSummaryString() {
        String result = "Best filter: " + this.getBestFilter().getClass().getName() + (this.getBestFilter() instanceof OptionHandler ? " " + Utils.joinOptions(((OptionHandler)((Object)this.getBestFilter())).getOptions()) : "") + "\n" + "Best classifier: " + this.getBestClassifier().getClass().getName() + " " + Utils.joinOptions(this.getBestClassifier().getOptions());
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9160 $");
    }

    public static void main(String[] args) {
        GridSearch.runClassifier(new GridSearch(), args);
    }

    protected class PerformanceCache
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 5838863230451530252L;
        protected Hashtable m_Cache = new Hashtable();

        protected PerformanceCache() {
        }

        protected String getID(int cv, PointDouble values) {
            return cv + "\t" + values.getX() + "\t" + values.getY();
        }

        public boolean isCached(int cv, PointDouble values) {
            return this.get(cv, values) != null;
        }

        public Performance get(int cv, PointDouble values) {
            return (Performance)this.m_Cache.get(this.getID(cv, values));
        }

        public void add(int cv, Performance p) {
            this.m_Cache.put(this.getID(cv, p.getValues()), p);
        }

        public String toString() {
            return this.m_Cache.toString();
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9160 $");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PerformanceTable
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 5486491313460338379L;
        protected Grid m_Grid;
        protected Vector<Performance> m_Performances;
        protected int m_Type;
        protected double[][] m_Table;
        protected double m_Min;
        protected double m_Max;

        public PerformanceTable(Grid grid, Vector<Performance> performances, int type) {
            this.m_Grid = grid;
            this.m_Type = type;
            this.m_Performances = performances;
            this.generate();
        }

        protected void generate() {
            this.m_Table = new double[this.getGrid().height()][this.getGrid().width()];
            this.m_Min = 0.0;
            this.m_Max = 0.0;
            for (int i = 0; i < this.getPerformances().size(); ++i) {
                Performance perf = this.getPerformances().get(i);
                PointInt location = this.getGrid().getLocation(perf.getValues());
                this.m_Table[this.getGrid().height() - (int)location.getY() - 1][(int)location.getX()] = perf.getPerformance(this.getType());
                if (i == 0) {
                    this.m_Max = this.m_Min = perf.getPerformance(this.m_Type);
                    continue;
                }
                if (perf.getPerformance(this.m_Type) < this.m_Min) {
                    this.m_Min = perf.getPerformance(this.m_Type);
                }
                if (!(perf.getPerformance(this.m_Type) > this.m_Max)) continue;
                this.m_Max = perf.getPerformance(this.m_Type);
            }
        }

        public Grid getGrid() {
            return this.m_Grid;
        }

        public Vector<Performance> getPerformances() {
            return this.m_Performances;
        }

        public int getType() {
            return this.m_Type;
        }

        public double[][] getTable() {
            return this.m_Table;
        }

        public double getMin() {
            return this.m_Min;
        }

        public double getMax() {
            return this.m_Max;
        }

        public String toString() {
            String result = "Table (" + new SelectedTag(this.getType(), TAGS_EVALUATION).getSelectedTag().getReadable() + ") - " + "X: " + this.getGrid().getLabelX() + ", Y: " + this.getGrid().getLabelY() + ":\n";
            for (int i = 0; i < this.getTable().length; ++i) {
                if (i > 0) {
                    result = result + "\n";
                }
                for (int n = 0; n < this.getTable()[i].length; ++n) {
                    if (n > 0) {
                        result = result + ",";
                    }
                    result = result + this.getTable()[i][n];
                }
            }
            return result;
        }

        public String toGnuplot() {
            StringBuffer result = new StringBuffer();
            Tag type = new SelectedTag(this.getType(), TAGS_EVALUATION).getSelectedTag();
            result.append("Gnuplot (" + type.getReadable() + "):\n");
            result.append("# begin 'gridsearch.data'\n");
            result.append("# " + type.getReadable() + "\n");
            for (int i = 0; i < this.getPerformances().size(); ++i) {
                result.append(this.getPerformances().get(i).toGnuplot(type.getID()) + "\n");
            }
            result.append("# end 'gridsearch.data'\n\n");
            result.append("# begin 'gridsearch.plot'\n");
            result.append("# " + type.getReadable() + "\n");
            result.append("set data style lines\n");
            result.append("set contour base\n");
            result.append("set surface\n");
            result.append("set title '" + GridSearch.this.m_Data.relationName() + "'\n");
            result.append("set xrange [" + this.getGrid().getMinX() + ":" + this.getGrid().getMaxX() + "]\n");
            result.append("set xlabel 'x (" + GridSearch.this.getFilter().getClass().getName() + ": " + GridSearch.this.getXProperty() + ")'\n");
            result.append("set yrange [" + this.getGrid().getMinY() + ":" + this.getGrid().getMaxY() + "]\n");
            result.append("set ylabel 'y - (" + GridSearch.this.getClassifier().getClass().getName() + ": " + GridSearch.this.getYProperty() + ")'\n");
            result.append("set zrange [" + (this.getMin() - (this.getMax() - this.getMin()) * 0.1) + ":" + (this.getMax() + (this.getMax() - this.getMin()) * 0.1) + "]\n");
            result.append("set zlabel 'z - " + type.getReadable() + "'\n");
            result.append("set dgrid3d " + this.getGrid().height() + "," + this.getGrid().width() + ",1\n");
            result.append("show contour\n");
            result.append("splot 'gridsearch.data'\n");
            result.append("pause -1\n");
            result.append("# end 'gridsearch.plot'");
            return result.toString();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9160 $");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PerformanceComparator
    implements Comparator<Performance>,
    Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 6507592831825393847L;
        protected int m_Evaluation;

        public PerformanceComparator(int evaluation) {
            this.m_Evaluation = evaluation;
        }

        public int getEvaluation() {
            return this.m_Evaluation;
        }

        @Override
        public int compare(Performance o1, Performance o2) {
            double p2;
            double p1 = o1.getPerformance(this.getEvaluation());
            int result = Utils.sm(p1, p2 = o2.getPerformance(this.getEvaluation())) ? -1 : (Utils.gr(p1, p2) ? 1 : 0);
            if (this.getEvaluation() != 0 && this.getEvaluation() != 6 && this.getEvaluation() != 7) {
                result = -result;
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof PerformanceComparator)) {
                throw new IllegalArgumentException("Must be PerformanceComparator!");
            }
            return this.m_Evaluation == ((PerformanceComparator)obj).m_Evaluation;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9160 $");
        }
    }

    protected class Performance
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -4374706475277588755L;
        protected PointDouble m_Values;
        protected double m_CC;
        protected double m_RMSE;
        protected double m_RRSE;
        protected double m_MAE;
        protected double m_RAE;
        protected double m_ACC;
        protected double m_Kappa;

        public Performance(PointDouble values, Evaluation evaluation) throws Exception {
            this.m_Values = values;
            this.m_RMSE = evaluation.rootMeanSquaredError();
            this.m_RRSE = evaluation.rootRelativeSquaredError();
            this.m_MAE = evaluation.meanAbsoluteError();
            this.m_RAE = evaluation.relativeAbsoluteError();
            try {
                this.m_CC = evaluation.correlationCoefficient();
            }
            catch (Exception e) {
                this.m_CC = Double.NaN;
            }
            try {
                this.m_ACC = evaluation.pctCorrect();
            }
            catch (Exception e) {
                this.m_ACC = Double.NaN;
            }
            try {
                this.m_Kappa = evaluation.kappa();
            }
            catch (Exception e) {
                this.m_Kappa = Double.NaN;
            }
        }

        public double getPerformance(int evaluation) {
            double result = Double.NaN;
            switch (evaluation) {
                case 0: {
                    result = this.m_CC;
                    break;
                }
                case 1: {
                    result = this.m_RMSE;
                    break;
                }
                case 2: {
                    result = this.m_RRSE;
                    break;
                }
                case 3: {
                    result = this.m_MAE;
                    break;
                }
                case 4: {
                    result = this.m_RAE;
                    break;
                }
                case 5: {
                    result = 1.0 - StrictMath.abs(this.m_CC) + this.m_RRSE + this.m_RAE;
                    break;
                }
                case 6: {
                    result = this.m_ACC;
                    break;
                }
                case 7: {
                    result = this.m_Kappa;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Evaluation type '" + evaluation + "' not supported!");
                }
            }
            return result;
        }

        public PointDouble getValues() {
            return this.m_Values;
        }

        public String toString(int evaluation) {
            String result = "Performance (" + this.getValues() + "): " + this.getPerformance(evaluation) + " (" + new SelectedTag(evaluation, TAGS_EVALUATION) + ")";
            return result;
        }

        public String toGnuplot(int evaluation) {
            String result = this.getValues().getX() + "\t" + this.getValues().getY() + "\t" + this.getPerformance(evaluation);
            return result;
        }

        public String toString() {
            String result = "Performance (" + this.getValues() + "): ";
            for (int i = 0; i < TAGS_EVALUATION.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + this.getPerformance(TAGS_EVALUATION[i].getID()) + " (" + new SelectedTag(TAGS_EVALUATION[i].getID(), TAGS_EVALUATION) + ")";
            }
            return result;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9160 $");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Grid
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 7290732613611243139L;
        protected double m_MinX;
        protected double m_MaxX;
        protected double m_StepX;
        protected String m_LabelX;
        protected double m_MinY;
        protected double m_MaxY;
        protected double m_StepY;
        protected String m_LabelY;
        protected int m_Width;
        protected int m_Height;

        public Grid(double minX, double maxX, double stepX, double minY, double maxY, double stepY) {
            this(minX, maxX, stepX, "", minY, maxY, stepY, "");
        }

        public Grid(double minX, double maxX, double stepX, String labelX, double minY, double maxY, double stepY, String labelY) {
            this.m_MinX = minX;
            this.m_MaxX = maxX;
            this.m_StepX = stepX;
            this.m_LabelX = labelX;
            this.m_MinY = minY;
            this.m_MaxY = maxY;
            this.m_StepY = stepY;
            this.m_LabelY = labelY;
            this.m_Height = (int)StrictMath.round((this.m_MaxY - this.m_MinY) / this.m_StepY) + 1;
            this.m_Width = (int)StrictMath.round((this.m_MaxX - this.m_MinX) / this.m_StepX) + 1;
            if (this.m_MinX >= this.m_MaxX) {
                throw new IllegalArgumentException("XMin must be smaller than XMax!");
            }
            if (this.m_MinY >= this.m_MaxY) {
                throw new IllegalArgumentException("YMin must be smaller than YMax!");
            }
            if (this.m_StepX <= 0.0) {
                throw new IllegalArgumentException("XStep must be a positive number!");
            }
            if (this.m_StepY <= 0.0) {
                throw new IllegalArgumentException("YStep must be a positive number!");
            }
            if (!Utils.eq(this.m_MinX + (double)(this.m_Width - 1) * this.m_StepX, this.m_MaxX)) {
                throw new IllegalArgumentException("X axis doesn't match! Provided max: " + this.m_MaxX + ", calculated max via min and step size: " + (this.m_MinX + (double)(this.m_Width - 1) * this.m_StepX));
            }
            if (!Utils.eq(this.m_MinY + (double)(this.m_Height - 1) * this.m_StepY, this.m_MaxY)) {
                throw new IllegalArgumentException("Y axis doesn't match! Provided max: " + this.m_MaxY + ", calculated max via min and step size: " + (this.m_MinY + (double)(this.m_Height - 1) * this.m_StepY));
            }
        }

        public boolean equals(Object o) {
            Grid g = (Grid)o;
            boolean result = this.width() == g.width() && this.height() == g.height() && this.getMinX() == g.getMinX() && this.getMinY() == g.getMinY() && this.getStepX() == g.getStepX() && this.getStepY() == g.getStepY() && this.getLabelX().equals(g.getLabelX()) && this.getLabelY().equals(g.getLabelY());
            return result;
        }

        public double getMinX() {
            return this.m_MinX;
        }

        public double getMaxX() {
            return this.m_MaxX;
        }

        public double getStepX() {
            return this.m_StepX;
        }

        public String getLabelX() {
            return this.m_LabelX;
        }

        public double getMinY() {
            return this.m_MinY;
        }

        public double getMaxY() {
            return this.m_MaxY;
        }

        public double getStepY() {
            return this.m_StepY;
        }

        public String getLabelY() {
            return this.m_LabelY;
        }

        public int height() {
            return this.m_Height;
        }

        public int width() {
            return this.m_Width;
        }

        public PointDouble getValues(int x, int y) {
            if (x >= this.width()) {
                throw new IllegalArgumentException("Index out of scope on X axis (" + x + " >= " + this.width() + ")!");
            }
            if (y >= this.height()) {
                throw new IllegalArgumentException("Index out of scope on Y axis (" + y + " >= " + this.height() + ")!");
            }
            return new PointDouble(this.m_MinX + this.m_StepX * (double)x, this.m_MinY + this.m_StepY * (double)y);
        }

        public PointInt getLocation(PointDouble values) {
            double currDistance;
            int i;
            int x = 0;
            double distance = this.m_StepX;
            for (i = 0; i < this.width(); ++i) {
                currDistance = StrictMath.abs(values.getX() - this.getValues(i, 0).getX());
                if (!Utils.sm(currDistance, distance)) continue;
                distance = currDistance;
                x = i;
            }
            int y = 0;
            distance = this.m_StepY;
            for (i = 0; i < this.height(); ++i) {
                currDistance = StrictMath.abs(values.getY() - this.getValues(0, i).getY());
                if (!Utils.sm(currDistance, distance)) continue;
                distance = currDistance;
                y = i;
            }
            PointInt result = new PointInt(x, y);
            return result;
        }

        public boolean isOnBorder(PointDouble values) {
            return this.isOnBorder(this.getLocation(values));
        }

        public boolean isOnBorder(PointInt location) {
            if (location.getX() == 0.0) {
                return true;
            }
            if (location.getX() == (double)(this.width() - 1)) {
                return true;
            }
            if (location.getY() == 0.0) {
                return true;
            }
            return location.getY() == (double)(this.height() - 1);
        }

        public Grid subgrid(int top, int left, int bottom, int right) {
            return new Grid(this.getValues(left, top).getX(), this.getValues(right, top).getX(), this.getStepX(), this.getLabelX(), this.getValues(left, bottom).getY(), this.getValues(left, top).getY(), this.getStepY(), this.getLabelY());
        }

        public Grid extend(PointDouble values) {
            double distance;
            double minX = Utils.smOrEq(values.getX(), this.getMinX()) ? (Utils.eq(distance = this.getMinX() - values.getX(), 0.0) ? this.getMinX() - this.getStepX() * (double)(StrictMath.round(distance / this.getStepX()) + 1L) : this.getMinX() - this.getStepX() * (double)StrictMath.round(distance / this.getStepX())) : this.getMinX();
            double maxX = Utils.grOrEq(values.getX(), this.getMaxX()) ? (Utils.eq(distance = values.getX() - this.getMaxX(), 0.0) ? this.getMaxX() + this.getStepX() * (double)(StrictMath.round(distance / this.getStepX()) + 1L) : this.getMaxX() + this.getStepX() * (double)StrictMath.round(distance / this.getStepX())) : this.getMaxX();
            double minY = Utils.smOrEq(values.getY(), this.getMinY()) ? (Utils.eq(distance = this.getMinY() - values.getY(), 0.0) ? this.getMinY() - this.getStepY() * (double)(StrictMath.round(distance / this.getStepY()) + 1L) : this.getMinY() - this.getStepY() * (double)StrictMath.round(distance / this.getStepY())) : this.getMinY();
            double maxY = Utils.grOrEq(values.getY(), this.getMaxY()) ? (Utils.eq(distance = values.getY() - this.getMaxY(), 0.0) ? this.getMaxY() + this.getStepY() * (double)(StrictMath.round(distance / this.getStepY()) + 1L) : this.getMaxY() + this.getStepY() * (double)StrictMath.round(distance / this.getStepY())) : this.getMaxY();
            Grid result = new Grid(minX, maxX, this.getStepX(), this.getLabelX(), minY, maxY, this.getStepY(), this.getLabelY());
            if (this.equals(result)) {
                throw new IllegalStateException("Grid extension failed!");
            }
            return result;
        }

        public Enumeration<PointDouble> row(int y) {
            Vector<PointDouble> result = new Vector<PointDouble>();
            for (int i = 0; i < this.width(); ++i) {
                result.add(this.getValues(i, y));
            }
            return result.elements();
        }

        public Enumeration<PointDouble> column(int x) {
            Vector<PointDouble> result = new Vector<PointDouble>();
            for (int i = 0; i < this.height(); ++i) {
                result.add(this.getValues(x, i));
            }
            return result.elements();
        }

        public String toString() {
            String result = "X: " + this.m_MinX + " - " + this.m_MaxX + ", Step " + this.m_StepX;
            if (this.m_LabelX.length() != 0) {
                result = result + " (" + this.m_LabelX + ")";
            }
            result = result + "\n";
            result = result + "Y: " + this.m_MinY + " - " + this.m_MaxY + ", Step " + this.m_StepY;
            if (this.m_LabelY.length() != 0) {
                result = result + " (" + this.m_LabelY + ")";
            }
            result = result + "\n";
            result = result + "Dimensions (Rows x Columns): " + this.height() + " x " + this.width();
            return result;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9160 $");
        }
    }

    protected class PointInt
    extends Point
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -5900415163698021618L;

        public PointInt(int x, int y) {
            super(x, y);
        }

        public String toString() {
            return super.toString().replaceAll(".*\\[", "[");
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9160 $");
        }
    }

    protected class PointDouble
    extends Point2D.Double
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 7151661776161898119L;

        public PointDouble(double x, double y) {
            super(x, y);
        }

        public boolean equals(Object obj) {
            PointDouble pd = (PointDouble)obj;
            return Utils.eq(this.getX(), pd.getX()) && Utils.eq(this.getY(), pd.getY());
        }

        public String toString() {
            return super.toString().replaceAll(".*\\[", "[");
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9160 $");
        }
    }
}

