/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.Visible;

@KFStep(category="Tools", toolTipText="Sort instances in ascending or descending order")
public class Sorter
extends JPanel
implements BeanCommon,
Visible,
Serializable,
DataSource,
DataSourceListener,
TrainingSetListener,
TestSetListener,
InstanceListener,
EventConstraints,
StructureProducer,
EnvironmentHandler {
    private static final long serialVersionUID = 4978227384322482115L;
    protected transient Logger m_log;
    protected Object m_listenee;
    protected String m_connectionType;
    protected InstanceEvent m_ie = new InstanceEvent(this);
    protected boolean m_busy;
    protected AtomicBoolean m_stopRequested;
    protected String m_sortDetails;
    protected transient Environment m_env;
    protected transient SortComparator m_sortComparator;
    protected transient List<InstanceHolder> m_incrementalBuffer;
    protected transient List<File> m_bufferFiles;
    protected String m_bufferSize = "10000";
    protected int m_bufferSizeI = 10000;
    protected Map<String, Integer> m_stringAttIndexes;
    protected String m_tempDirectory = "";
    protected transient int m_streamCounter = 0;
    private Instances m_connectedFormat;
    protected BeanVisual m_visual = new BeanVisual("Sorter", "weka/gui/beans/icons/Sorter.gif", "weka/gui/beans/icons/Sorter_animated.gif");
    protected ArrayList<DataSourceListener> m_dataListeners = new ArrayList();
    protected ArrayList<InstanceListener> m_instanceListeners = new ArrayList();

    public Sorter() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
        this.m_stopRequested = new AtomicBoolean(false);
    }

    public String globalInfo() {
        return "Sorts incoming instances in ascending or descending order according to the values of user specified attributes. Instances can be sorted according to multiple attributes (defined in order). Handles data sets larger than can be fit into main memory via instance connections and specifying the in-memory buffer size. Implements a merge-sort by writing the sorted in-memory buffer to a file when full and then interleaving instances from the disk based file(s) when the incoming stream has finished.";
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        EventConstraints ec;
        if (this.m_listenee == null) {
            return false;
        }
        if (!eventName.equals("instance") && !eventName.equals("dataSet")) {
            return false;
        }
        if (this.m_listenee instanceof DataSource && this.m_listenee instanceof EventConstraints) {
            EventConstraints ec2 = (EventConstraints)this.m_listenee;
            return ec2.eventGeneratable(eventName);
        }
        if (this.m_listenee instanceof TrainingSetProducer && this.m_listenee instanceof EventConstraints) {
            ec = (EventConstraints)this.m_listenee;
            if (!eventName.equals("dataSet")) {
                return false;
            }
            if (!ec.eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (this.m_listenee instanceof TestSetProducer && this.m_listenee instanceof EventConstraints) {
            ec = (EventConstraints)this.m_listenee;
            if (!eventName.equals("dataSet")) {
                return false;
            }
            if (!ec.eventGeneratable("testSet")) {
                return false;
            }
        }
        return true;
    }

    private void copyStringAttVals(InstanceHolder holder) {
        for (String attName : this.m_stringAttIndexes.keySet()) {
            Attribute att = holder.m_instance.dataset().attribute(attName);
            String val = holder.m_instance.stringValue(att);
            if (holder.m_stringVals == null) {
                holder.m_stringVals = new HashMap<String, String>();
            }
            holder.m_stringVals.put(attName, val);
        }
    }

    @Override
    public void acceptInstance(InstanceEvent e) {
        if (e.getStatus() == 0) {
            block13: {
                this.m_connectedFormat = e.getStructure();
                this.m_stopRequested.set(false);
                try {
                    this.init(new Instances(e.getStructure(), 0));
                }
                catch (IllegalArgumentException ex) {
                    if (this.m_log == null) break block13;
                    String message = "ERROR: There is a problem with the incoming instance structure";
                    this.m_log.statusMessage(message + " - see log for details");
                    this.m_log.logMessage(this.statusMessagePrefix() + message + " :" + ex.getMessage());
                }
            }
            String buffSize = this.m_bufferSize;
            try {
                buffSize = this.m_env.substitute(buffSize);
                this.m_bufferSizeI = Integer.parseInt(buffSize);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.m_incrementalBuffer = new ArrayList<InstanceHolder>(this.m_bufferSizeI);
            this.m_bufferFiles = new ArrayList<File>();
            this.m_streamCounter = 0;
            return;
        }
        this.m_busy = true;
        if (e.getInstance() != null) {
            if (this.m_streamCounter == 0 && this.m_log != null) {
                this.m_log.statusMessage(this.statusMessagePrefix() + "Starting streaming sort...");
                this.m_log.logMessage("[Sorter] " + this.statusMessagePrefix() + " Using streaming buffer size: " + this.m_bufferSizeI);
            }
            InstanceHolder tempH = new InstanceHolder();
            tempH.m_instance = e.getInstance();
            tempH.m_fileNumber = -1;
            if (this.m_stringAttIndexes != null) {
                this.copyStringAttVals(tempH);
            }
            this.m_incrementalBuffer.add(tempH);
            ++this.m_streamCounter;
        }
        if (e.getInstance() == null || e.getStatus() == 2) {
            this.emitBufferedInstances();
            return;
        }
        if (this.m_incrementalBuffer.size() == this.m_bufferSizeI) {
            try {
                this.sortBuffer(true);
            }
            catch (Exception ex) {
                String msg = this.statusMessagePrefix() + "ERROR: unable to write to temp file.";
                if (this.m_log != null) {
                    this.m_log.statusMessage(msg);
                    this.m_log.logMessage("[" + this.getCustomName() + "] " + msg);
                }
                this.stop();
                ex.printStackTrace();
                this.m_busy = false;
                return;
            }
        }
        this.m_busy = false;
    }

    protected void emitBufferedInstances() {
        Thread t = new Thread(){

            @Override
            public void run() {
                InstanceHolder tempH;
                int mergeCount = 0;
                if (Sorter.this.m_incrementalBuffer.size() > 0 && !Sorter.this.m_stopRequested.get()) {
                    try {
                        Sorter.this.sortBuffer(false);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (Sorter.this.m_bufferFiles.size() == 0) {
                        if (Sorter.this.m_stopRequested.get()) {
                            Sorter.this.m_busy = false;
                            return;
                        }
                        String msg = Sorter.this.statusMessagePrefix() + "Emitting in memory buffer....";
                        if (Sorter.this.m_log != null) {
                            Sorter.this.m_log.statusMessage(msg);
                            Sorter.this.m_log.logMessage("[" + Sorter.this.getCustomName() + "] " + msg);
                        }
                        Instances newHeader = new Instances(Sorter.this.m_incrementalBuffer.get((int)0).m_instance.dataset(), 0);
                        Sorter.this.m_ie.setStructure(newHeader);
                        Sorter.this.notifyInstanceListeners(Sorter.this.m_ie);
                        for (int i = 0; i < Sorter.this.m_incrementalBuffer.size(); ++i) {
                            InstanceHolder currentH = Sorter.this.m_incrementalBuffer.get(i);
                            currentH.m_instance.setDataset(newHeader);
                            if (Sorter.this.m_stringAttIndexes != null) {
                                for (String attName : Sorter.this.m_stringAttIndexes.keySet()) {
                                    boolean setValToZero = newHeader.attribute(attName).numValues() > 0;
                                    String valToSetInHeader = currentH.m_stringVals.get(attName);
                                    newHeader.attribute(attName).setStringValue(valToSetInHeader);
                                    if (!setValToZero) continue;
                                    currentH.m_instance.setValue(newHeader.attribute(attName), 0.0);
                                }
                            }
                            if (Sorter.this.m_stopRequested.get()) {
                                Sorter.this.m_busy = false;
                                return;
                            }
                            Sorter.this.m_ie.setInstance(currentH.m_instance);
                            Sorter.this.m_ie.setStatus(1);
                            if (i == Sorter.this.m_incrementalBuffer.size() - 1) {
                                Sorter.this.m_ie.setStatus(2);
                            }
                            Sorter.this.notifyInstanceListeners(Sorter.this.m_ie);
                        }
                        return;
                    }
                }
                ArrayList<ObjectInputStream> inputStreams = new ArrayList<ObjectInputStream>();
                ArrayList<InstanceHolder> merger = new ArrayList<InstanceHolder>();
                Instances tempHeader = new Instances(Sorter.this.m_connectedFormat, 0);
                Sorter.this.m_ie.setStructure(tempHeader);
                Sorter.this.notifyInstanceListeners(Sorter.this.m_ie);
                if (Sorter.this.m_incrementalBuffer.size() > 0) {
                    InstanceHolder tempH2 = Sorter.this.m_incrementalBuffer.remove(0);
                    merger.add(tempH2);
                }
                if (Sorter.this.m_stopRequested.get()) {
                    Sorter.this.m_busy = false;
                    return;
                }
                if (Sorter.this.m_bufferFiles.size() > 0) {
                    String msg = Sorter.this.statusMessagePrefix() + "Merging temp files...";
                    if (Sorter.this.m_log != null) {
                        Sorter.this.m_log.statusMessage(msg);
                        Sorter.this.m_log.logMessage("[" + Sorter.this.getCustomName() + "] " + msg);
                    }
                }
                for (int i = 0; i < Sorter.this.m_bufferFiles.size(); ++i) {
                    ObjectInputStream ois = null;
                    try {
                        FileInputStream fis = new FileInputStream(Sorter.this.m_bufferFiles.get(i));
                        BufferedInputStream bis = new BufferedInputStream(fis, 50000);
                        ois = new ObjectInputStream(bis);
                        tempH = (InstanceHolder)ois.readObject();
                        if (tempH != null) {
                            inputStreams.add(ois);
                            tempH.m_fileNumber = i;
                            merger.add(tempH);
                            continue;
                        }
                        ois.close();
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (ois == null) continue;
                        try {
                            ois.close();
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                Collections.sort(merger, Sorter.this.m_sortComparator);
                do {
                    if (Sorter.this.m_stopRequested.get()) {
                        Sorter.this.m_busy = false;
                        break;
                    }
                    InstanceHolder holder = (InstanceHolder)merger.remove(0);
                    holder.m_instance.setDataset(tempHeader);
                    if (Sorter.this.m_stringAttIndexes != null) {
                        for (String attName : Sorter.this.m_stringAttIndexes.keySet()) {
                            boolean setValToZero = tempHeader.attribute(attName).numValues() > 1;
                            String valToSetInHeader = holder.m_stringVals.get(attName);
                            tempHeader.attribute(attName).setStringValue(valToSetInHeader);
                            if (!setValToZero) continue;
                            holder.m_instance.setValue(tempHeader.attribute(attName), 0.0);
                        }
                    }
                    if (Sorter.this.m_stopRequested.get()) {
                        Sorter.this.m_busy = false;
                        break;
                    }
                    Sorter.this.m_ie.setInstance(holder.m_instance);
                    Sorter.this.m_ie.setStatus(1);
                    Sorter.this.notifyInstanceListeners(Sorter.this.m_ie);
                    if (++mergeCount % Sorter.this.m_bufferSizeI == 0 && Sorter.this.m_log != null) {
                        String msg = Sorter.this.statusMessagePrefix() + "Merged " + mergeCount + " instances";
                        if (Sorter.this.m_log != null) {
                            Sorter.this.m_log.statusMessage(msg);
                        }
                    }
                    int smallest = holder.m_fileNumber;
                    InstanceHolder nextH = null;
                    if (smallest == -1) {
                        if (Sorter.this.m_incrementalBuffer.size() > 0) {
                            nextH = Sorter.this.m_incrementalBuffer.remove(0);
                            nextH.m_fileNumber = -1;
                        }
                    } else {
                        ObjectInputStream tis = (ObjectInputStream)inputStreams.get(smallest);
                        try {
                            tempH = (InstanceHolder)tis.readObject();
                            if (tempH == null) {
                                throw new Exception("end of buffer");
                            }
                            nextH = tempH;
                            nextH.m_fileNumber = smallest;
                        }
                        catch (Exception ex) {
                            try {
                                if (Sorter.this.m_log != null) {
                                    String msg = Sorter.this.statusMessagePrefix() + "Closing temp file";
                                    Sorter.this.m_log.statusMessage(msg);
                                }
                                tis.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            File file = Sorter.this.m_bufferFiles.remove(smallest);
                            file.delete();
                            inputStreams.remove(smallest);
                            for (InstanceHolder h : merger) {
                                if (h.m_fileNumber == -1 || h.m_fileNumber <= smallest) continue;
                                --h.m_fileNumber;
                            }
                        }
                    }
                    if (nextH == null) continue;
                    int index = Collections.binarySearch(merger, nextH, Sorter.this.m_sortComparator);
                    if (index < 0) {
                        merger.add(index * -1 - 1, nextH);
                    } else {
                        merger.add(index, nextH);
                    }
                    nextH = null;
                } while (merger.size() > 0 && !Sorter.this.m_stopRequested.get());
                if (!Sorter.this.m_stopRequested.get()) {
                    Sorter.this.m_ie.setInstance(null);
                    Sorter.this.m_ie.setStatus(2);
                    Sorter.this.notifyInstanceListeners(Sorter.this.m_ie);
                    String msg = Sorter.this.statusMessagePrefix() + "Finished.";
                    if (Sorter.this.m_log != null) {
                        Sorter.this.m_log.statusMessage(msg);
                        Sorter.this.m_log.logMessage("[" + Sorter.this.getCustomName() + "] " + msg);
                    }
                    Sorter.this.m_busy = false;
                } else {
                    for (ObjectInputStream is : inputStreams) {
                        try {
                            is.close();
                        }
                        catch (Exception ex) {}
                    }
                    Sorter.this.m_busy = false;
                }
            }
        };
        t.setPriority(1);
        t.start();
    }

    protected void sortBuffer(boolean write) throws Exception {
        String msg = this.statusMessagePrefix() + "Sorting in memory buffer....";
        if (this.m_log != null) {
            this.m_log.statusMessage(msg);
            this.m_log.logMessage("[" + this.getCustomName() + "] " + msg);
        }
        Collections.sort(this.m_incrementalBuffer, this.m_sortComparator);
        if (!write) {
            return;
        }
        String tmpDir = this.m_tempDirectory;
        File tempFile = File.createTempFile("Sorter", ".tmp");
        if (tmpDir != null && tmpDir.length() > 0) {
            try {
                tmpDir = this.m_env.substitute(tmpDir);
                File tempDir = new File(tmpDir);
                if (tempDir.exists() && tempDir.canWrite()) {
                    File newFile;
                    String filename = tempFile.getName();
                    tempFile = newFile = new File(tmpDir + File.separator + filename);
                    tempFile.deleteOnExit();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!this.m_stopRequested.get()) {
            this.m_bufferFiles.add(tempFile);
            FileOutputStream fos = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 50000);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            msg = this.statusMessagePrefix() + "Writing buffer to temp file " + this.m_bufferFiles.size() + "...";
            if (this.m_log != null) {
                this.m_log.statusMessage(msg);
                this.m_log.logMessage("[" + this.getCustomName() + "] " + msg);
            }
            for (int i = 0; i < this.m_incrementalBuffer.size(); ++i) {
                InstanceHolder temp = this.m_incrementalBuffer.get(i);
                temp.m_instance.setDataset(null);
                oos.writeObject(temp);
                if (i % (this.m_bufferSizeI / 10) != 0) continue;
                oos.reset();
            }
            bos.flush();
            oos.close();
        }
        this.m_incrementalBuffer.clear();
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        Instances test = e.getTestSet();
        DataSetEvent d = new DataSetEvent(this, test);
        this.acceptDataSet(d);
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances train = e.getTrainingSet();
        DataSetEvent d = new DataSetEvent(this, train);
        this.acceptDataSet(d);
    }

    protected void init(Instances structure) {
        ArrayList<SortRule> sortRules = new ArrayList<SortRule>();
        if (this.m_sortDetails != null && this.m_sortDetails.length() > 0) {
            String[] sortParts;
            for (String s : sortParts = this.m_sortDetails.split("@@sort-rule@@")) {
                SortRule r = new SortRule(s.trim());
                r.init(this.m_env, structure);
                sortRules.add(r);
            }
            this.m_sortComparator = new SortComparator(sortRules);
        }
        this.m_stringAttIndexes = new HashMap<String, Integer>();
        for (int i = 0; i < structure.numAttributes(); ++i) {
            if (!structure.attribute(i).isString()) continue;
            this.m_stringAttIndexes.put(structure.attribute(i).name(), new Integer(i));
        }
        if (this.m_stringAttIndexes.size() == 0) {
            this.m_stringAttIndexes = null;
        }
    }

    public String getBufferSize() {
        return this.m_bufferSize;
    }

    public void setBufferSize(String buffSize) {
        this.m_bufferSize = buffSize;
    }

    public void setTempDirectory(String tempDir) {
        this.m_tempDirectory = tempDir;
    }

    public String getTempDirectory() {
        return this.m_tempDirectory;
    }

    public void setSortDetails(String sortDetails) {
        this.m_sortDetails = sortDetails;
    }

    public String getSortDetails() {
        return this.m_sortDetails;
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        block7: {
            this.m_busy = true;
            this.m_stopRequested.set(false);
            if (this.m_log != null && e.getDataSet().numInstances() > 0) {
                this.m_log.statusMessage(this.statusMessagePrefix() + "Sorting batch...");
            }
            if (e.isStructureOnly()) {
                DataSetEvent d = new DataSetEvent(this, e.getDataSet());
                this.notifyDataListeners(d);
                this.m_busy = false;
                return;
            }
            try {
                this.init(new Instances(e.getDataSet(), 0));
            }
            catch (IllegalArgumentException ex) {
                if (this.m_log == null) break block7;
                String message = "ERROR: There is a problem with the incoming instance structure";
                this.m_log.statusMessage(message + " - see log for details");
                this.m_log.logMessage(this.statusMessagePrefix() + message + " :" + ex.getMessage());
                this.stop();
                this.m_busy = false;
                return;
            }
        }
        ArrayList<InstanceHolder> instances = new ArrayList<InstanceHolder>();
        for (int i = 0; i < e.getDataSet().numInstances(); ++i) {
            InstanceHolder h = new InstanceHolder();
            h.m_instance = e.getDataSet().instance(i);
            instances.add(h);
        }
        Collections.sort(instances, this.m_sortComparator);
        Instances output = new Instances(e.getDataSet(), 0);
        for (int i = 0; i < instances.size(); ++i) {
            output.add(((InstanceHolder)instances.get((int)i)).m_instance);
        }
        DataSetEvent d = new DataSetEvent(this, output);
        this.notifyDataListeners(d);
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Finished.");
        }
        this.m_busy = false;
    }

    @Override
    public void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.add(dsl);
    }

    @Override
    public void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.remove(dsl);
    }

    @Override
    public void addInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.add(dsl);
    }

    @Override
    public void removeInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.remove(dsl);
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/Sorter.gif", "weka/gui/beans/icons/Sorter_animated.gif");
        this.m_visual.setText("Sorter");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
        if (this.m_listenee != null && this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Stopped");
        }
        this.m_busy = false;
        this.m_stopRequested.set(true);
    }

    @Override
    public boolean isBusy() {
        return this.m_busy;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        if (!(eventName.equals("instance") || eventName.equals("dataSet") || eventName.equals("trainingSet") || eventName.equals("testSet"))) {
            return false;
        }
        return this.m_listenee == null;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
            this.m_connectionType = eventName;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        if (source == this.m_listenee) {
            this.m_listenee = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInstanceListeners(InstanceEvent e) {
        List l;
        Sorter sorter = this;
        synchronized (sorter) {
            l = (List)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (InstanceListener il : l) {
                il.acceptInstance(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataListeners(DataSetEvent e) {
        List l;
        Sorter sorter = this;
        synchronized (sorter) {
            l = (List)this.m_dataListeners.clone();
        }
        if (l.size() > 0) {
            for (DataSourceListener ds : l) {
                ds.acceptDataSet(e);
            }
        }
    }

    protected String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }

    private Instances getUpstreamStructure() {
        if (this.m_listenee != null && this.m_listenee instanceof StructureProducer) {
            return ((StructureProducer)this.m_listenee).getStructure(this.m_connectionType);
        }
        return null;
    }

    @Override
    public Instances getStructure(String eventName) {
        if (!eventName.equals("dataSet") && !eventName.equals("instance")) {
            return null;
        }
        if (eventName.equals("dataSet") && this.m_dataListeners.size() == 0) {
            return null;
        }
        if (eventName.equals("instance") && this.m_instanceListeners.size() == 0) {
            return null;
        }
        if (this.m_connectedFormat == null) {
            this.m_connectedFormat = this.getUpstreamStructure();
        }
        return this.m_connectedFormat;
    }

    public Instances getConnectedFormat() {
        if (this.m_connectedFormat == null) {
            this.m_connectedFormat = this.getUpstreamStructure();
        }
        return this.m_connectedFormat;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    protected static class SortRule
    implements Comparator<InstanceHolder> {
        protected String m_attributeNameOrIndex;
        protected Attribute m_attribute;
        protected boolean m_descending;

        public SortRule(String att, boolean descending) {
            this.m_attributeNameOrIndex = att;
            this.m_descending = descending;
        }

        public SortRule() {
        }

        public SortRule(String setup) {
            this.parseFromInternal(setup);
        }

        protected void parseFromInternal(String setup) {
            String[] parts = setup.split("@@SR@@");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Malformed sort rule: " + setup);
            }
            this.m_attributeNameOrIndex = parts[0].trim();
            this.m_descending = parts[1].equalsIgnoreCase("Y");
        }

        protected String toStringInternal() {
            return this.m_attributeNameOrIndex + "@@SR@@" + (this.m_descending ? "Y" : "N");
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("Attribute: " + this.m_attributeNameOrIndex + " - sort " + (this.m_descending ? "descending" : "ascending"));
            return res.toString();
        }

        public void setAttribute(String att) {
            this.m_attributeNameOrIndex = att;
        }

        public String getAttribute() {
            return this.m_attributeNameOrIndex;
        }

        public void setDescending(boolean d) {
            this.m_descending = d;
        }

        public boolean getDescending() {
            return this.m_descending;
        }

        public void init(Environment env, Instances structure) {
            String attNameI = this.m_attributeNameOrIndex;
            try {
                attNameI = env.substitute(attNameI);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (attNameI.equalsIgnoreCase("/first")) {
                this.m_attribute = structure.attribute(0);
            } else if (attNameI.equalsIgnoreCase("/last")) {
                this.m_attribute = structure.attribute(structure.numAttributes() - 1);
            } else {
                this.m_attribute = structure.attribute(attNameI);
                if (this.m_attribute == null) {
                    try {
                        int index = Integer.parseInt(attNameI);
                        this.m_attribute = structure.attribute(index);
                    }
                    catch (NumberFormatException n) {
                        throw new IllegalArgumentException("Unable to locate attribute " + attNameI + " as either a named attribute or as a valid " + "attribute index");
                    }
                }
            }
        }

        @Override
        public int compare(InstanceHolder o1, InstanceHolder o2) {
            if (o1.m_instance.isMissing(this.m_attribute) && o2.m_instance.isMissing(this.m_attribute)) {
                return 0;
            }
            if (o1.m_instance.isMissing(this.m_attribute)) {
                return 1;
            }
            if (o2.m_instance.isMissing(this.m_attribute)) {
                return -1;
            }
            int cmp = 0;
            if (!this.m_attribute.isString() && !this.m_attribute.isRelationValued()) {
                double val1 = o1.m_instance.value(this.m_attribute);
                double val2 = o2.m_instance.value(this.m_attribute);
                cmp = Double.compare(val1, val2);
            } else if (this.m_attribute.isString()) {
                String val1 = o1.m_stringVals.get(this.m_attribute.name());
                String val2 = o2.m_stringVals.get(this.m_attribute.name());
                cmp = val1.compareTo(val2);
            } else {
                throw new IllegalArgumentException("Can't sort according to relation-valued attribute values!");
            }
            if (this.m_descending) {
                return -cmp;
            }
            return cmp;
        }
    }

    protected static class SortComparator
    implements Comparator<InstanceHolder> {
        protected List<SortRule> m_sortRules;

        public SortComparator(List<SortRule> sortRules) {
            this.m_sortRules = sortRules;
        }

        @Override
        public int compare(InstanceHolder o1, InstanceHolder o2) {
            int cmp = 0;
            for (SortRule sr : this.m_sortRules) {
                cmp = sr.compare(o1, o2);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    protected static class InstanceHolder
    implements Serializable {
        private static final long serialVersionUID = -3985730394250172995L;
        protected Instance m_instance;
        protected int m_fileNumber;
        protected Map<String, String> m_stringVals;

        protected InstanceHolder() {
        }
    }
}

