/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class PropertyNode
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -8718165742572631384L;
    public Object value;
    public Class parentClass;
    public PropertyDescriptor property;

    public PropertyNode(Object pValue) {
        this(pValue, null, null);
    }

    public PropertyNode(Object pValue, PropertyDescriptor prop, Class pClass) {
        this.value = pValue;
        this.property = prop;
        this.parentClass = pClass;
    }

    public String toString() {
        if (this.property == null) {
            return "Available properties";
        }
        return this.property.getDisplayName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(this.value);
        }
        catch (Exception ex) {
            throw new IOException("Can't serialize object: " + ex.getMessage());
        }
        out.writeObject(this.parentClass);
        out.writeObject(this.property.getDisplayName());
        out.writeObject(this.property.getReadMethod().getName());
        out.writeObject(this.property.getWriteMethod().getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
        this.parentClass = (Class)in.readObject();
        String name = (String)in.readObject();
        String getter = (String)in.readObject();
        String setter = (String)in.readObject();
        try {
            this.property = new PropertyDescriptor(name, this.parentClass, getter, setter);
        }
        catch (IntrospectionException ex) {
            throw new ClassNotFoundException("Couldn't create property descriptor: " + this.parentClass.getName() + "::" + name);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

