/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class AbstractClassifier
implements Classifier,
Cloneable,
Serializable,
OptionHandler,
CapabilitiesHandler,
RevisionHandler {
    private static final long serialVersionUID = 6502780192411755341L;
    protected boolean m_Debug = false;

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        if (dist == null) {
            throw new Exception("Null distribution predicted");
        }
        switch (instance.classAttribute().type()) {
            case 1: {
                double max = 0.0;
                int maxIndex = 0;
                for (int i = 0; i < dist.length; ++i) {
                    if (!(dist[i] > max)) continue;
                    maxIndex = i;
                    max = dist[i];
                }
                if (max > 0.0) {
                    return maxIndex;
                }
                return Utils.missingValue();
            }
            case 0: {
                return dist[0];
            }
        }
        return Utils.missingValue();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dist = new double[instance.numClasses()];
        switch (instance.classAttribute().type()) {
            case 1: {
                double classification = this.classifyInstance(instance);
                if (Utils.isMissingValue(classification)) {
                    return dist;
                }
                dist[(int)classification] = 1.0;
                return dist;
            }
            case 0: {
                dist[0] = this.classifyInstance(instance);
                return dist;
            }
        }
        return dist;
    }

    public static Classifier forName(String classifierName, String[] options) throws Exception {
        return (AbstractClassifier)Utils.forName(Classifier.class, classifierName, options);
    }

    public static Classifier makeCopy(Classifier model) throws Exception {
        return (Classifier)new SerializedObject(model).getObject();
    }

    public static Classifier[] makeCopies(Classifier model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model classifier set");
        }
        Classifier[] classifiers = new Classifier[num];
        SerializedObject so = new SerializedObject(model);
        for (int i = 0; i < classifiers.length; ++i) {
            classifiers[i] = (Classifier)so.getObject();
        }
        return classifiers;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tIf set, classifier is run in debug mode and\n\tmay output additional info to the console", "D", 0, "-D"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
    }

    @Override
    public String[] getOptions() {
        String[] options = this.getDebug() ? new String[]{"-D"} : new String[]{};
        return options;
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, classifier may output additional info to the console.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAll();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void runClassifier(Classifier classifier, String[] options) {
        try {
            System.out.println(Evaluation.evaluateModel(classifier, options));
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf("General options") == -1 || e.getMessage() == null) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
    }
}

