/*
 * Decompiled with CFR 0.152.
 */
package profiler;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import profiler.ProfileUtils;
import profiler.Result;

public class ResultList<T> {
    private int colCount;
    private int colWidth = 8;
    private Map<String, Collection<Result<T>>> results = new LinkedHashMap<String, Collection<Result<T>>>();

    public ResultList(int colCount, int colWidth) {
        this.colCount = colCount;
        this.colWidth = colWidth;
    }

    public void addResult(String name, Collection<Result<T>> currResults) {
        Collection<Result<T>> prevResults = this.results.get(name = ProfileUtils.formatFileName(name, 2 * this.colWidth));
        if (prevResults == null) {
            this.results.put(name, currResults);
        } else {
            Iterator<Result<T>> prev = prevResults.iterator();
            Iterator<Result<T>> curr = currResults.iterator();
            while (prev.hasNext()) {
                prev.next().addIteration(curr.next());
            }
        }
    }

    public void print() {
        this.printHeader(this.results.values().iterator().next());
        for (Map.Entry<String, Collection<Result<T>>> entry : this.results.entrySet()) {
            String name = entry.getKey();
            Collection<Result<T>> result = entry.getValue();
            this.printDataset(name, result);
        }
        System.out.println();
    }

    private void printDataset(String name, Collection<Result<T>> results) {
        System.out.format("%-" + 2 * this.colWidth + "s|", name);
        for (Result<T> result : results) {
            System.out.format("%" + this.colWidth + ".2f |", result.getAvgTime());
            if (this.colCount <= 1) continue;
            System.out.format("%" + this.colWidth + ".2f |", result.getAvgMemory());
        }
        System.out.println();
    }

    private void printHeader(Collection<Result<T>> results) {
        System.out.println();
        System.out.println();
        System.out.format("%-" + 2 * this.colWidth + "s|", " ");
        int headerWidth = this.colCount * this.colWidth;
        for (Result<T> result : results) {
            String colHeader = result.getTask().toString();
            if (colHeader.length() > headerWidth) {
                colHeader = colHeader.substring(0, headerWidth - 1) + '.';
            }
            System.out.format(" %-" + headerWidth + "s", colHeader);
            for (int i = 0; i < 2 * (this.colCount - 1); ++i) {
                System.out.print(" ");
            }
            System.out.print("|");
        }
        System.out.println();
        System.out.format("%-" + 2 * this.colWidth + "s|", " ");
        for (int i = 0; i < results.size(); ++i) {
            System.out.format(" %-" + this.colWidth + "s|", "Time");
            if (this.colCount <= 1) continue;
            System.out.format(" %-" + this.colWidth + "s|", "Mem");
        }
        System.out.println();
    }
}

