/*
 * Decompiled with CFR 0.152.
 */
package profiler;

import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.MemUtils;
import org.mindswap.pellet.utils.VersionInfo;
import profiler.ProfileUtils;
import profiler.Result;
import profiler.ResultList;
import profiler.utils.IObjectProfileNode;
import profiler.utils.ObjectProfiler;

public class ProfileKB {
    private double memPercentageLimit = 0.05;
    private int iterations = 1;
    private MemoryProfiling memoryProfiling = MemoryProfiling.APPROX;
    private Task task = Task.Consistency;
    private LoaderType loaderType = LoaderType.JENA;
    private boolean imports = true;
    private final PrintWriter out = new PrintWriter(System.out);

    public static void main(String[] args) throws Exception {
        new ProfileKB().run(args);
    }

    public static List<String> readConfigFile(String configFile) throws IOException {
        ArrayList<String> datasets = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(configFile));
        String line = null;
        while ((line = in.readLine()) != null && line.length() > 0) {
            datasets.add(line);
        }
        in.close();
        return datasets;
    }

    public void setMemoryProfiling(MemoryProfiling memoryProfiling) {
        this.memoryProfiling = memoryProfiling;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setLoaderType(LoaderType loaderType) {
        this.loaderType = loaderType;
    }

    public List<String> parseArgs(String[] args) throws Exception {
        List<String> datasets = null;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("memory", 1, null, 109), new LongOpt("task", 1, null, 116), new LongOpt("percentage", 1, null, 112), new LongOpt("repeat", 1, null, 114), new LongOpt("ontology", 1, null, 111), new LongOpt("file", 1, null, 102), new LongOpt("loader", 1, null, 108), new LongOpt("imports", 1, null, 105)};
        Getopt g = new Getopt(ProfileKB.class.toString(), args, "hm:t:p:r:o:f:l:i:", longopts);
        try {
            int c;
            block20: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 104: {
                        System.exit(0);
                    }
                    case 108: {
                        String interfaceName = g.getOptarg().toUpperCase();
                        try {
                            this.loaderType = LoaderType.valueOf(interfaceName);
                        }
                        catch (IllegalArgumentException e) {
                            ProfileUtils.error("Task " + interfaceName + " is not one of " + Arrays.toString((Object[])LoaderType.values()));
                        }
                        continue block20;
                    }
                    case 116: {
                        String taskName = g.getOptarg();
                        try {
                            this.task = Task.valueOf(taskName);
                        }
                        catch (IllegalArgumentException e) {
                            ProfileUtils.error("Task " + taskName + " is not one of " + Arrays.toString((Object[])Task.values()));
                        }
                        continue block20;
                    }
                    case 112: {
                        this.memPercentageLimit = Double.parseDouble(g.getOptarg());
                        continue block20;
                    }
                    case 109: {
                        String s = g.getOptarg();
                        try {
                            this.memoryProfiling = MemoryProfiling.valueOf(s.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            ProfileUtils.error("Memory profiling " + s + " is not one of " + Arrays.toString((Object[])MemoryProfiling.values()));
                        }
                        continue block20;
                    }
                    case 114: {
                        this.iterations = Integer.parseInt(g.getOptarg());
                        continue block20;
                    }
                    case 102: {
                        String configFile = g.getOptarg();
                        datasets = ProfileKB.readConfigFile(configFile);
                        continue block20;
                    }
                    case 111: {
                        String ontology = g.getOptarg();
                        datasets = Arrays.asList(ontology);
                        continue block20;
                    }
                    case 105: {
                        this.imports = Boolean.parseBoolean(g.getOptarg());
                        continue block20;
                    }
                    case 63: {
                        ProfileUtils.error("The option '" + (char)g.getOptopt() + "' is not valid");
                    }
                }
                ProfileUtils.error("Unrecognized option: " + (char)c);
            }
        }
        catch (NumberFormatException e) {
            ProfileUtils.error("Invalid number: " + e);
        }
        if (datasets == null) {
            ProfileUtils.error("No config file (-f) or input ontology (-o) provided!");
        }
        return datasets;
    }

    private void print(IObjectProfileNode node) {
        StringBuilder sb = new StringBuilder();
        int pLimit = node.pathlength();
        for (int p = 0; p < pLimit; ++p) {
            sb.append("  ");
        }
        IObjectProfileNode root = node.root();
        IObjectProfileNode[] children = node.children();
        double sizeInMB = ProfileUtils.mb(node.size());
        sb.append(String.format("%.2f", sizeInMB));
        if (node != root) {
            double percent = (double)node.size() / (double)root.size();
            if (percent <= this.memPercentageLimit) {
                return;
            }
            sb.append(" (");
            sb.append(String.format("%2.1f%%", 100.0 * percent));
            sb.append(")");
        }
        sb.append(" -> ");
        String name = node.name();
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0) {
            name = name.substring(lastDot + 1);
        }
        sb.append(name);
        if (node.object() != null) {
            if (node.name().endsWith("#table") || node.name().endsWith("#elementData")) {
                int n;
                IObjectProfileNode shell = null;
                for (int i = n = children.length - 1; i >= 0 && (shell = children[i]).object() != null; --i) {
                }
                int size = node.size() - shell.size();
                double avg = (double)size / (double)n;
                sb.append(" children: " + n + " avg: " + avg + " " + shell.name() + " " + ProfileUtils.mb(shell.size()));
            } else {
                sb.append(" : ");
                sb.append(ObjectProfiler.typeName(node.object().getClass(), true));
                if (node.refcount() > 1) {
                    sb.append(", refcount=");
                    sb.append(node.refcount());
                }
            }
        }
        this.out.println(sb);
        this.out.flush();
        for (IObjectProfileNode child : children) {
            this.print(child);
        }
    }

    private double printProfile(KnowledgeBase kb, KBLoader loader, String header) {
        long mem = 0L;
        KBLoader obj = loader;
        block0 : switch (this.memoryProfiling) {
            case NONE: {
                break;
            }
            case KB_SIZE: {
                obj = kb;
            }
            case ALL_SIZE: {
                System.out.println(header);
                mem = ObjectProfiler.sizeof(obj, ATermUtils.getFactory());
                MemUtils.printMemory((String)"Size: ", (long)mem);
                break;
            }
            case KB_VERBOSE: {
                obj = kb;
            }
            case ALL_VERBOSE: {
                System.out.println(header);
                IObjectProfileNode profile = ObjectProfiler.profile(obj);
                this.print(profile);
                mem = profile.size();
                for (IObjectProfileNode node : profile.children()) {
                    if (node.object() == null || !node.object().equals(ATermUtils.getFactory())) continue;
                    mem -= (long)node.size();
                    break block0;
                }
                break;
            }
            case APPROX: {
                System.out.println(header);
                MemUtils.printMemory((String)"Total: ", (long)MemUtils.totalMemory());
                MemUtils.printMemory((String)"Free : ", (long)MemUtils.freeMemory());
                MemUtils.printMemory((String)"Used*: ", (long)(MemUtils.totalMemory() - MemUtils.freeMemory()));
                MemUtils.runGC();
                mem = MemUtils.usedMemory();
                MemUtils.printMemory((String)"Used : ", (long)mem);
            }
        }
        System.out.println();
        return ProfileUtils.mb(mem);
    }

    public Collection<Result<Task>> profile(String ... files) {
        JenaLoader loader = this.loaderType == LoaderType.JENA ? new JenaLoader() : new OWLAPILoader();
        loader.setIgnoreImports(!this.imports);
        KnowledgeBase kb = loader.getKB();
        ArrayList<Result<Task>> results = new ArrayList<Result<Task>>();
        for (int i = 0; i <= this.task.ordinal(); ++i) {
            Task task = Task.values()[i];
            long start = System.currentTimeMillis();
            switch (task) {
                case Parse: {
                    loader.parse(FileUtils.getFileURIsFromRegex((String[])files).toArray(new String[0]));
                    break;
                }
                case Load: {
                    loader.load();
                    ProfileUtils.printCounts(kb);
                    break;
                }
                case Consistency: {
                    kb.isConsistent();
                    ProfileUtils.printCounts(kb.getABox());
                    break;
                }
                case Classify: {
                    kb.classify();
                    break;
                }
                case Realize: {
                    kb.realize();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("This task does not exist: " + (Object)((Object)task)));
                }
            }
            double time = (double)(System.currentTimeMillis() - start) / 1000.0;
            double mem = task.requiresInstances() && kb.getABox().isEmpty() ? ((Result)results.get(results.size() - 1)).getAvgMemory() : this.printProfile(kb, (KBLoader)loader, "After " + (Object)((Object)task));
            results.add(new Result<Task>(task, mem, time));
        }
        kb.timers.print();
        loader.clear();
        return results;
    }

    public void run(String[] args) {
        try {
            List<String> datasets = this.parseArgs(args);
            int colCount = this.memoryProfiling == MemoryProfiling.NONE ? 1 : 2;
            int colWidth = 8;
            ResultList results = new ResultList(colCount, colWidth);
            for (int i = 0; i < this.iterations; ++i) {
                System.out.println("\n\n\nITERATION: " + (i + 1) + "\n\n\n");
                for (String dataset : datasets) {
                    try {
                        String[] files = dataset.split(" ");
                        String name = files[0];
                        Collection currResults = this.profile(files);
                        results.addResult(name, currResults);
                        System.out.println("\n\n\nRESULT " + (i + 1) + ":");
                        System.out.println("Version: " + VersionInfo.getInstance().getVersionString());
                        results.print();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static enum Task {
        Parse(false),
        Load(false),
        Consistency(true),
        Classify(false),
        Realize(true);

        private boolean requiresInstances;

        private Task(boolean requiresInstances) {
            this.requiresInstances = requiresInstances;
        }

        boolean requiresInstances() {
            return this.requiresInstances;
        }
    }

    public static enum MemoryProfiling {
        APPROX,
        ALL_SIZE,
        ALL_VERBOSE,
        KB_SIZE,
        KB_VERBOSE,
        NONE;

    }

    public static enum LoaderType {
        JENA,
        OWLAPI;

    }
}

