/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.RuleBasedELClassifier;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.builtins.NotEqual;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;

public class JenaBasedELClassifier
extends RuleBasedELClassifier
implements TaxonomyBuilder {
    private static final String PREDICATE_PREFIX = "tag:clarkparsia.com,2008:pellet:el:predicate:";
    private static final Node PRED_SUB = Node.createURI((String)"tag:clarkparsia.com,2008:pellet:el:predicate:subclassOf");
    private static final Builtin NOT_EQUAL = new NotEqual();
    private final Node TOP;
    private final Node BOTTOM;
    private NameStore m_Names = new NameStore();
    private VariableStore m_Variables = new VariableStore();
    private Set<Rule> m_Rules = CollectionUtils.makeSet();
    private Graph m_Facts = GraphFactory.createDefaultGraph();

    public JenaBasedELClassifier() {
        this.TOP = this.m_Names.get(ATermUtils.TOP);
        this.BOTTOM = this.m_Names.get(ATermUtils.BOTTOM);
        this.makeRuleAxioms();
    }

    protected void addClasses(Collection<ATermAppl> classes) {
        for (ATermAppl c : classes) {
            Node n = this.m_Names.get(c);
            this.m_Facts.add(Triple.create((Node)n, (Node)PRED_SUB, (Node)n));
            this.m_Facts.add(Triple.create((Node)n, (Node)PRED_SUB, (Node)this.TOP));
        }
    }

    @Override
    protected MultiValueMap<ATermAppl, ATermAppl> run(Collection<ATermAppl> classes) {
        this.addClasses(classes);
        this.addClasses(this.m_Names.getAllAnons());
        GenericRuleReasoner reasoner = new GenericRuleReasoner(new ArrayList<Rule>(this.m_Rules));
        InfGraph inf = reasoner.bind(this.m_Facts);
        inf.prepare();
        MultiValueMap<ATermAppl, ATermAppl> subsumers = this.getSubsumptions((Graph)inf);
        for (ATermAppl c : classes) {
            subsumers.add(ATermUtils.BOTTOM, c);
        }
        return subsumers;
    }

    protected MultiValueMap<ATermAppl, ATermAppl> getSubsumptions(Graph graph) {
        MultiValueMap<ATermAppl, ATermAppl> subsumers = new MultiValueMap<ATermAppl, ATermAppl>();
        ExtendedIterator it = graph.find(Node.ANY, PRED_SUB, Node.ANY);
        while (it.hasNext()) {
            Triple tri = (Triple)it.next();
            Node sub = tri.getSubject();
            Node sup = tri.getObject();
            if (NameStore.isAnon(sub) || NameStore.isAnon(sup)) continue;
            subsumers.add(this.toATermAppl(sub), this.toATermAppl(sup));
        }
        it.close();
        return subsumers;
    }

    private ATermAppl toATermAppl(Node n) {
        if (this.TOP.hasURI(n.getURI())) {
            return ATermUtils.TOP;
        }
        if (this.BOTTOM.hasURI(n.getURI())) {
            return ATermUtils.BOTTOM;
        }
        return ATermUtils.makeTermAppl(n.getURI());
    }

    @Override
    protected void addSubclassRule(ATermAppl sub, ATermAppl sup) {
        this.addSubclassRule(sub, sup, new FreeVariableStore());
    }

    @Override
    protected void addRoleDomainRule(ATermAppl p, ATermAppl domain) {
        List body = CollectionUtils.makeList();
        List<ClauseEntry> head = CollectionUtils.makeList();
        FreeVariableStore freeVar = new FreeVariableStore();
        Node var0 = freeVar.next();
        Node var1 = freeVar.next();
        body.add(this.makeSubOfSomeTriple(var0, p, var1));
        this.translateSuper(head, domain, freeVar, var0);
        this.m_Rules.add(new Rule(head, body));
    }

    @Override
    protected void addRoleRangeRule(ATermAppl p, ATermAppl range) {
        List body = CollectionUtils.makeList();
        List<ClauseEntry> head = CollectionUtils.makeList();
        FreeVariableStore freeVar = new FreeVariableStore();
        Node var0 = freeVar.next();
        Node var1 = freeVar.next();
        body.add(this.makeSubOfSomeTriple(var0, p, var1));
        ATermAppl someOfRange = ATermUtils.makeSomeValues((ATerm)p, (ATerm)range);
        this.translateSuper(head, someOfRange, freeVar, var0);
        this.m_Rules.add(new Rule(head, body));
    }

    @Override
    protected void addRoleChainRule(ATerm[] chain, ATermAppl sup) {
        if (chain.length < 1) {
            return;
        }
        List body = CollectionUtils.makeList();
        FreeVariableStore freeVar = new FreeVariableStore();
        Node[] var = new Node[chain.length + 1];
        var[0] = freeVar.next();
        for (int i = 0; i < chain.length; ++i) {
            var[i + 1] = freeVar.next();
            body.add(this.makeSubOfSomeTriple(var[i], (ATermAppl)chain[i], var[i + 1]));
        }
        TriplePattern head = this.makeSubOfSomeTriple(var[0], sup, var[var.length - 1]);
        this.m_Rules.add(new Rule(Collections.singletonList(head), body));
    }

    @Override
    protected void addRoleHierarchyRule(ATermAppl sub, ATermAppl sup) {
        this.addRoleChainRule(new ATerm[]{sub}, sup);
    }

    private void makeRuleAxioms() {
        this.makeBottomAxiom();
    }

    private void makeBottomAxiom() {
        FreeVariableStore freeVar = new FreeVariableStore();
        Node var0 = freeVar.next();
        Node var1 = freeVar.next();
        Node var2 = freeVar.next();
        List body = CollectionUtils.makeList();
        body.add(this.makeSubOfSomeTriple(var0, var1, var2));
        body.add(this.makePropertyAssertionFunctor(var1));
        body.add(this.makeSubclassTriple(var2, this.BOTTOM));
        TriplePattern head = this.makeSubclassTriple(var0, this.BOTTOM);
        this.m_Rules.add(new Rule(Collections.singletonList(head), body));
    }

    private void addSubclassRule(ATermAppl sub, ATermAppl sup, FreeVariableStore freeVar) {
        List<ClauseEntry> body = CollectionUtils.makeList();
        List<ClauseEntry> head = CollectionUtils.makeList();
        Node var = freeVar.next();
        this.translateSub(body, sub, freeVar, var);
        this.translateSuper(head, sup, freeVar, var);
        this.m_Rules.add(new Rule(head, body));
    }

    private void translateSub(List<ClauseEntry> outBody, ATermAppl sub, FreeVariableStore freeVar, Node currentVar) {
        AFun fun = sub.getAFun();
        if (ATermUtils.isPrimitive(sub) || ATermUtils.isBottom(sub)) {
            outBody.add((ClauseEntry)this.makeSubclassTriple(currentVar, this.m_Names.get(sub)));
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)sub.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.translateSub(outBody, conj, freeVar, currentVar);
                list = list.getNext();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl prop = (ATermAppl)sub.getArgument(0);
            ATermAppl q = (ATermAppl)sub.getArgument(1);
            Node nextVar = freeVar.next();
            outBody.add((ClauseEntry)this.makeSubOfSomeTriple(currentVar, prop, nextVar));
            this.translateSub(outBody, q, freeVar, nextVar);
        } else assert (false);
    }

    private void translateSuper(List<ClauseEntry> outHead, ATermAppl sup, FreeVariableStore freeVar, Node currentVar) {
        AFun fun = sup.getAFun();
        if (ATermUtils.isPrimitive(sup) || ATermUtils.isBottom(sup)) {
            outHead.add((ClauseEntry)this.makeSubclassTriple(currentVar, this.m_Names.get(sup)));
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)sup.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.translateSuper(outHead, conj, freeVar, currentVar);
                list = list.getNext();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl prop = (ATermAppl)sup.getArgument(0);
            ATermAppl q = (ATermAppl)sup.getArgument(1);
            if (!ATermUtils.isPrimitive(q) && !ATermUtils.isBottom(q)) {
                ATermAppl anon = this.m_Names.getNextAnon();
                this.translateSuperSome(anon, q);
                q = anon;
            }
            outHead.add((ClauseEntry)this.makeSubOfSomeTriple(currentVar, prop, this.m_Names.get(q)));
        } else assert (false);
    }

    private void translateSuperSome(ATermAppl anon, ATermAppl sup) {
        AFun fun = sup.getAFun();
        if (ATermUtils.isPrimitive(sup) || ATermUtils.isBottom(sup)) {
            this.m_Facts.add(this.makeSubclassFact(anon, sup));
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)sup.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.translateSuperSome(anon, conj);
                list = list.getNext();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl prop = (ATermAppl)sup.getArgument(0);
            ATermAppl q = (ATermAppl)sup.getArgument(1);
            if (!ATermUtils.isPrimitive(q) && !ATermUtils.isBottom(q)) {
                ATermAppl nextAnon = this.m_Names.getNextAnon();
                this.translateSuperSome(nextAnon, q);
                q = nextAnon;
            }
            this.m_Facts.add(this.makeSubOfSomeFact(anon, prop, q));
        } else assert (false);
    }

    private Triple makeSubclassFact(ATermAppl t1, ATermAppl t2) {
        return this.makeSubclassFact(this.m_Names.get(t1), this.m_Names.get(t2));
    }

    private Triple makeSubclassFact(Node t1, Node t2) {
        return Triple.create((Node)t1, (Node)PRED_SUB, (Node)t2);
    }

    private Triple makeSubOfSomeFact(ATermAppl t1, ATermAppl t2, ATermAppl t3) {
        return Triple.create((Node)this.m_Names.get(t1), (Node)this.m_Names.get(t2), (Node)this.m_Names.get(t3));
    }

    private TriplePattern makeSubclassTriple(Node t1, Node t2) {
        return new TriplePattern(t1, PRED_SUB, t2);
    }

    private TriplePattern makeSubOfSomeTriple(Node t1, ATermAppl p, Node t2) {
        return this.makeSubOfSomeTriple(t1, this.m_Names.get(p), t2);
    }

    private TriplePattern makeSubOfSomeTriple(Node t1, Node p, Node t2) {
        return new TriplePattern(t1, p, t2);
    }

    private Functor makePropertyAssertionFunctor(Node p) {
        Functor f = new Functor("isNotSubClass", new Node[]{p, PRED_SUB});
        f.setImplementor(NOT_EQUAL);
        return f;
    }

    class FreeVariableStore {
        private int m_Next = 0;

        FreeVariableStore() {
        }

        public Node next() {
            return JenaBasedELClassifier.this.m_Variables.get(this.m_Next++);
        }
    }

    static class VariableStore {
        private static final String PREFIX = "x";
        private List<Node> m_Variables = CollectionUtils.makeList();

        VariableStore() {
        }

        public Node get(int target) {
            for (int size = this.m_Variables.size(); size <= target; ++size) {
                this.m_Variables.add((Node)new Node_RuleVariable(PREFIX + size, size));
            }
            return this.m_Variables.get(target);
        }
    }

    static class NameStore {
        private static final String ANON = "tag:clarkparsia.com,2008:pellet:el:anon:";
        private static final int FIRST_ANON = 0;
        private Map<ATermAppl, Node> m_Constants = CollectionUtils.makeMap();
        private int m_NextAnon = 0;

        NameStore() {
        }

        public Node get(ATermAppl term) {
            Node c = this.m_Constants.get(term);
            if (c == null) {
                c = term == ATermUtils.BOTTOM ? Node.createURI((String)"_BOTTOM_") : Node.createURI((String)term.getName());
                this.m_Constants.put(term, c);
            }
            return c;
        }

        public ATermAppl getNextAnon() {
            return NameStore.makeAnon(this.m_NextAnon++);
        }

        public Set<ATermAppl> getAllAnons() {
            Set<ATermAppl> anons = CollectionUtils.makeSet();
            for (int i = 0; i < this.m_NextAnon; ++i) {
                anons.add(NameStore.makeAnon(i));
            }
            return anons;
        }

        public static boolean isAnon(Node c) {
            return c.getURI().startsWith(ANON);
        }

        private static ATermAppl makeAnon(int id) {
            return ATermUtils.makeTermAppl(ANON + id);
        }
    }
}

