/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.IntervalRelations;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ContinuousRealInterval {
    private static final Logger log = Logger.getLogger(ContinuousRealInterval.class.getCanonicalName());
    private static ContinuousRealInterval unconstrained = new ContinuousRealInterval(null, null, true, true);
    private final boolean inclusiveLower;
    private final boolean inclusiveUpper;
    private final Number lower;
    private final boolean point;
    private final Number upper;

    public static ContinuousRealInterval allReals() {
        return unconstrained;
    }

    private static IntervalRelations compare(ContinuousRealInterval a, ContinuousRealInterval b) {
        int ll = ContinuousRealInterval.compareLowerLower(a, b);
        if (ll < 0) {
            int ul = ContinuousRealInterval.compareUpperLower(a, b);
            if (ul < 0) {
                return IntervalRelations.PRECEDES;
            }
            if (ul == 0) {
                if (a.inclusiveUpper()) {
                    if (b.inclusiveLower()) {
                        return IntervalRelations.OVERLAPS;
                    }
                    return IntervalRelations.MEETS;
                }
                if (b.inclusiveLower()) {
                    return IntervalRelations.MEETS;
                }
                return IntervalRelations.PRECEDES;
            }
            int uu = ContinuousRealInterval.compareUpperUpper(a, b);
            if (uu < 0) {
                return IntervalRelations.OVERLAPS;
            }
            if (uu == 0) {
                return IntervalRelations.FINISHED_BY;
            }
            return IntervalRelations.CONTAINS;
        }
        if (ll == 0) {
            int uu = ContinuousRealInterval.compareUpperUpper(a, b);
            if (uu < 0) {
                return IntervalRelations.STARTS;
            }
            if (uu == 0) {
                return IntervalRelations.EQUALS;
            }
            return IntervalRelations.STARTED_BY;
        }
        int lu = -ContinuousRealInterval.compareUpperLower(b, a);
        if (lu < 0) {
            int uu = ContinuousRealInterval.compareUpperUpper(a, b);
            if (uu < 0) {
                return IntervalRelations.DURING;
            }
            if (uu == 0) {
                return IntervalRelations.FINISHES;
            }
            return IntervalRelations.OVERLAPPED_BY;
        }
        if (lu == 0) {
            if (b.inclusiveUpper()) {
                if (a.inclusiveLower()) {
                    return IntervalRelations.OVERLAPPED_BY;
                }
                return IntervalRelations.MET_BY;
            }
            if (a.inclusiveLower()) {
                return IntervalRelations.MET_BY;
            }
            return IntervalRelations.PRECEDED_BY;
        }
        return IntervalRelations.PRECEDED_BY;
    }

    private static int compareLowerLower(ContinuousRealInterval a, ContinuousRealInterval other) {
        int ll;
        if (!a.boundLower()) {
            ll = !other.boundLower() ? 0 : -1;
        } else if (!other.boundLower()) {
            ll = 1;
        } else {
            ll = OWLRealUtils.compare(a.getLower(), other.getLower());
            if (ll == 0) {
                if (a.inclusiveLower()) {
                    if (!other.inclusiveLower()) {
                        ll = -1;
                    }
                } else if (other.inclusiveLower()) {
                    ll = 1;
                }
            }
        }
        return ll;
    }

    private static int compareUpperLower(ContinuousRealInterval a, ContinuousRealInterval b) {
        int ul = !a.boundUpper() ? 1 : (!b.boundLower() ? 1 : OWLRealUtils.compare(a.getUpper(), b.getLower()));
        return ul;
    }

    private static int compareUpperUpper(ContinuousRealInterval a, ContinuousRealInterval b) {
        int uu;
        if (!a.boundUpper()) {
            uu = !b.boundUpper() ? 0 : 1;
        } else if (!b.boundUpper()) {
            uu = -1;
        } else {
            uu = OWLRealUtils.compare(a.getUpper(), b.getUpper());
            if (uu == 0) {
                if (a.inclusiveUpper()) {
                    if (!b.inclusiveUpper()) {
                        uu = 1;
                    }
                } else if (b.inclusiveUpper()) {
                    uu = -1;
                }
            }
        }
        return uu;
    }

    public ContinuousRealInterval(Number point) {
        this.lower = point;
        this.upper = point;
        this.point = true;
        this.inclusiveLower = true;
        this.inclusiveUpper = true;
    }

    public ContinuousRealInterval(Number lower, Number upper, boolean inclusiveLower, boolean inclusiveUpper) {
        if (lower != null && upper != null) {
            int cmp = OWLRealUtils.compare(lower, upper);
            if (cmp > 0) {
                String msg = String.format("Lower bound of interval (%s) should not be greater than upper bound of interval (%s)", lower, upper);
                log.severe(msg);
                throw new IllegalArgumentException(msg);
            }
            if (!(cmp != 0 || inclusiveLower && inclusiveUpper)) {
                String msg = "Point intervals must be inclusive";
                log.severe("Point intervals must be inclusive");
                throw new IllegalArgumentException("Point intervals must be inclusive");
            }
        }
        this.lower = lower;
        this.upper = upper;
        this.inclusiveLower = lower == null ? false : inclusiveLower;
        this.inclusiveUpper = upper == null ? false : inclusiveUpper;
        this.point = lower != null && upper != null && lower.equals(upper);
    }

    public boolean boundLower() {
        return this.lower != null;
    }

    public boolean boundUpper() {
        return this.upper != null;
    }

    public boolean canUnionWith(ContinuousRealInterval other) {
        return EnumSet.complementOf(EnumSet.of(IntervalRelations.PRECEDES, IntervalRelations.PRECEDED_BY)).contains((Object)this.compare(other));
    }

    public IntervalRelations compare(ContinuousRealInterval other) {
        return ContinuousRealInterval.compare(this, other);
    }

    public boolean contains(Number n) {
        int comp;
        if (this.boundLower()) {
            comp = OWLRealUtils.compare(this.getLower(), n);
            if (comp > 0) {
                return false;
            }
            if (comp == 0 && !this.inclusiveLower()) {
                return false;
            }
        }
        if (this.boundUpper()) {
            comp = OWLRealUtils.compare(this.getUpper(), n);
            if (comp < 0) {
                return false;
            }
            if (comp == 0 && !this.inclusiveUpper()) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContinuousRealInterval other = (ContinuousRealInterval)obj;
        if (this.inclusiveLower != other.inclusiveLower) {
            return false;
        }
        if (this.inclusiveUpper != other.inclusiveUpper) {
            return false;
        }
        if (this.lower == null ? other.lower != null : OWLRealUtils.compare(this.lower, other.lower) != 0) {
            return false;
        }
        return !(this.upper == null ? other.upper != null : OWLRealUtils.compare(this.upper, other.upper) != 0);
    }

    public Number getLower() {
        return this.lower;
    }

    public Number getUpper() {
        return this.upper;
    }

    public ContinuousRealInterval greater(Number n) {
        if (this.boundLower() && OWLRealUtils.compare(n, this.getLower()) < 0) {
            return this;
        }
        if (this.boundUpper() && OWLRealUtils.compare(n, this.getUpper()) >= 0) {
            return null;
        }
        return new ContinuousRealInterval(n, this.getUpper(), false, this.inclusiveUpper());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inclusiveLower ? 1231 : 1237);
        result = 31 * result + (this.inclusiveUpper ? 1231 : 1237);
        result = 31 * result + (this.lower == null ? 0 : this.lower.hashCode());
        result = 31 * result + (this.upper == null ? 0 : this.upper.hashCode());
        return result;
    }

    public boolean inclusiveLower() {
        return this.inclusiveLower;
    }

    public boolean inclusiveUpper() {
        return this.inclusiveUpper;
    }

    public ContinuousRealInterval intersection(ContinuousRealInterval that) {
        boolean inclusiveUpper;
        Number upper;
        boolean inclusiveLower;
        Number lower;
        switch (this.compare(that)) {
            case CONTAINS: 
            case STARTED_BY: {
                lower = that.getLower();
                inclusiveLower = that.inclusiveLower();
                upper = that.getUpper();
                inclusiveUpper = that.inclusiveUpper();
                break;
            }
            case EQUALS: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper();
                break;
            }
            case DURING: 
            case STARTS: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper();
                break;
            }
            case FINISHED_BY: {
                lower = that.getLower();
                inclusiveLower = that.inclusiveLower();
                upper = that.getUpper();
                inclusiveUpper = this.inclusiveUpper() && that.inclusiveUpper();
                break;
            }
            case FINISHES: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper() && that.inclusiveUpper();
                break;
            }
            case MEETS: 
            case MET_BY: {
                return null;
            }
            case OVERLAPPED_BY: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = that.getUpper();
                inclusiveUpper = that.inclusiveUpper();
                break;
            }
            case OVERLAPS: {
                lower = that.getLower();
                inclusiveLower = that.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper();
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return null;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new ContinuousRealInterval(lower, upper, inclusiveLower, inclusiveUpper);
    }

    public boolean isPoint() {
        return this.point;
    }

    public ContinuousRealInterval less(Number n) {
        if (this.boundUpper() && OWLRealUtils.compare(n, this.getUpper()) > 0) {
            return this;
        }
        if (this.boundLower() && OWLRealUtils.compare(n, this.getLower()) <= 0) {
            return null;
        }
        return new ContinuousRealInterval(this.getLower(), n, this.inclusiveLower(), false);
    }

    public List<ContinuousRealInterval> remove(ContinuousRealInterval other) {
        ContinuousRealInterval after;
        ContinuousRealInterval before;
        switch (this.compare(other)) {
            case CONTAINS: {
                before = new ContinuousRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower());
                after = new ContinuousRealInterval(other.getUpper(), this.getUpper(), !other.inclusiveUpper(), this.inclusiveUpper());
                break;
            }
            case EQUALS: 
            case DURING: 
            case STARTS: 
            case FINISHES: {
                return Collections.emptyList();
            }
            case MEETS: {
                before = new ContinuousRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), false);
                after = null;
                break;
            }
            case MET_BY: {
                before = null;
                after = new ContinuousRealInterval(this.getLower(), this.getUpper(), false, this.inclusiveUpper());
                break;
            }
            case STARTED_BY: 
            case OVERLAPPED_BY: {
                before = null;
                after = new ContinuousRealInterval(other.getUpper(), this.getUpper(), !other.inclusiveUpper(), this.inclusiveUpper());
                break;
            }
            case FINISHED_BY: 
            case OVERLAPS: {
                before = new ContinuousRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower());
                after = null;
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Collections.singletonList(this);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ArrayList<ContinuousRealInterval> ret = new ArrayList<ContinuousRealInterval>();
        if (before != null) {
            ret.add(before);
        }
        if (after != null) {
            ret.add(after);
        }
        return ret;
    }

    public Number size() {
        if (!this.point) {
            throw new IllegalStateException();
        }
        return 1;
    }

    public String toString() {
        return String.format("%s%s,%s%s", this.inclusiveLower() ? "[" : "(", this.boundLower() ? this.getLower() : "-Inf", this.boundUpper() ? this.getUpper() : "+Inf", this.inclusiveUpper() ? "]" : ")");
    }

    public List<ContinuousRealInterval> union(ContinuousRealInterval other) {
        switch (this.compare(other)) {
            case CONTAINS: 
            case STARTED_BY: 
            case EQUALS: 
            case FINISHED_BY: {
                return Collections.singletonList(this);
            }
            case DURING: 
            case STARTS: 
            case FINISHES: {
                return Collections.singletonList(other);
            }
            case MEETS: {
                return Collections.singletonList(new ContinuousRealInterval(this.getLower(), other.getUpper(), this.inclusiveLower(), other.inclusiveUpper()));
            }
            case MET_BY: {
                return Collections.singletonList(new ContinuousRealInterval(other.getLower(), this.getUpper(), other.inclusiveLower(), this.inclusiveUpper()));
            }
            case OVERLAPPED_BY: {
                return Collections.singletonList(new ContinuousRealInterval(other.getLower(), this.getUpper(), other.inclusiveLower(), this.inclusiveUpper()));
            }
            case OVERLAPS: {
                return Collections.singletonList(new ContinuousRealInterval(this.getLower(), other.getUpper(), this.inclusiveLower(), other.inclusiveUpper()));
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Arrays.asList(this, other);
            }
        }
        throw new IllegalStateException();
    }

    public Iterator<Number> valueIterator() {
        if (this.isPoint()) {
            return Collections.singletonList(this.getUpper()).iterator();
        }
        throw new IllegalStateException();
    }
}

