/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.jena.graph.loader.DefaultGraphLoader;
import org.mindswap.pellet.jena.graph.loader.GraphLoader;

public class PelletReasoner
implements Reasoner {
    protected static Logger log = Logger.getLogger(PelletReasoner.class.getName());
    private Model reasonerCapabilities;
    private Capabilities graphCapabilities;
    private Graph schema;
    private boolean fixedSchema;

    public PelletReasoner() {
        this(null, PelletReasonerFactory.theInstance().getCapabilities());
    }

    public PelletReasoner(Graph schema) {
        this(schema, PelletReasonerFactory.theInstance().getCapabilities());
    }

    protected PelletReasoner(Model reasonerCapabilities) {
        this(null, reasonerCapabilities);
    }

    protected PelletReasoner(Graph schema, Model reasonerCapabilities) {
        this.schema = schema;
        this.reasonerCapabilities = reasonerCapabilities;
        this.graphCapabilities = new BaseInfGraph.InfFindSafeCapabilities();
    }

    public Graph getSchema() {
        return this.schema;
    }

    public boolean isFixedSchema() {
        return this.fixedSchema;
    }

    public void setFixedSchema(boolean fixedSchema) {
        this.fixedSchema = fixedSchema;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        return new PelletReasoner(graph, this.reasonerCapabilities);
    }

    public Reasoner bindSchema(Model model) throws ReasonerException {
        return this.bindSchema(model.getGraph());
    }

    public Reasoner bindFixedSchema(Graph graph) throws ReasonerException {
        PelletReasoner reasoner = new PelletReasoner(graph, this.reasonerCapabilities);
        reasoner.setFixedSchema(true);
        return reasoner;
    }

    public Reasoner bindFixedSchema(Model model) throws ReasonerException {
        PelletReasoner reasoner = new PelletReasoner(model.getGraph(), this.reasonerCapabilities);
        reasoner.setFixedSchema(true);
        return reasoner;
    }

    public PelletInfGraph bind(Graph graph) throws ReasonerException {
        log.fine("In bind!");
        return new PelletInfGraph(graph, this, (GraphLoader)new DefaultGraphLoader());
    }

    public InfModel bind(Model model) throws ReasonerException {
        log.fine("In bind!");
        return ModelFactory.createInfModel((InfGraph)this.bind(model.getGraph()));
    }

    public PelletInfGraph bind(KnowledgeBase kb) throws ReasonerException {
        return new PelletInfGraph(kb, this, (GraphLoader)new DefaultGraphLoader());
    }

    public void setDerivationLogging(boolean enable) {
    }

    public void setParameter(Property arg0, Object arg1) {
    }

    public Model getReasonerCapabilities() {
        return this.reasonerCapabilities;
    }

    public Capabilities getGraphCapabilities() {
        return this.graphCapabilities;
    }

    public void addDescription(Model arg0, Resource arg1) {
    }

    public boolean supportsProperty(Property property) {
        Model caps = this.getReasonerCapabilities();
        if (caps == null) {
            return false;
        }
        return caps.contains(null, ReasonerVocabulary.supportsP, (RDFNode)property);
    }
}

