/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.parser;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.FrameMergeException;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBOFormatParser {
    static final Logger LOG = LoggerFactory.getLogger(OBOFormatParser.class);
    private boolean followImport;
    private Object location;
    protected final MyStream stream;
    public final LoadingCache<String, String> stringCache;

    @Nonnull
    protected static SimpleDateFormat getISODateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public OBOFormatParser() {
        this(new MyStream());
    }

    protected OBOFormatParser(MyStream s) {
        this.stream = s;
        Weigher<String, String> stringWeigher = new Weigher<String, String>(){

            public int weigh(String key, String value) {
                return key.length();
            }
        };
        CacheLoader<String, String> loader = new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                return key;
            }
        };
        this.stringCache = LOG.isDebugEnabled() ? CacheBuilder.newBuilder().recordStats().maximumWeight(0x800000L).weigher((Weigher)stringWeigher).build((CacheLoader)loader) : CacheBuilder.newBuilder().maximumWeight(0x800000L).weigher((Weigher)stringWeigher).build((CacheLoader)loader);
    }

    public void setReader(BufferedReader r) {
        this.stream.reader = r;
    }

    public void setFollowImports(boolean followImports) {
        this.followImport = followImports;
    }

    public boolean getFollowImports() {
        return this.followImport;
    }

    @Nonnull
    public OBODoc parse(@Nonnull String fn) throws IOException {
        if (fn.startsWith("http:")) {
            return this.parse(new URL(fn));
        }
        return this.parse(new File(fn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public OBODoc parse(File file) throws IOException {
        this.location = file;
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            OBODoc oBODoc = this.parse(in);
            return oBODoc;
        }
    }

    @Nonnull
    public OBODoc parse(@Nonnull URL url) throws IOException {
        this.location = url;
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
        return this.parse(in);
    }

    @Nonnull
    public OBODoc parseURL(String urlstr) throws IOException {
        URL url = new URL(urlstr);
        return this.parse(url);
    }

    @Nonnull
    private String resolvePath(@Nonnull String inputPath) {
        String path = inputPath;
        if (!(path.startsWith("http:") || path.startsWith("file:") || path.startsWith("https:") || this.location == null)) {
            if (this.location instanceof URL) {
                URL url = (URL)this.location;
                String p = url.toString();
                int index = p.lastIndexOf(47);
                path = p.substring(0, index + 1) + path;
            } else {
                File f = new File(this.location.toString());
                f = new File(f.getParent(), path);
                path = f.toURI().toString();
            }
        }
        return path;
    }

    @Nonnull
    public OBODoc parse(BufferedReader reader) throws IOException {
        this.setReader(reader);
        OBODoc obodoc = new OBODoc();
        this.parseOBODoc(obodoc);
        Frame hf = obodoc.getHeaderFrame();
        LinkedList<OBODoc> imports = new LinkedList<OBODoc>();
        if (hf != null) {
            for (Clause cl : hf.getClauses(OBOFormatConstants.OboFormatTag.TAG_IMPORT)) {
                String path = this.resolvePath(cl.getValue(String.class));
                cl.setValue(path);
                if (!this.followImport) continue;
                OBOFormatParser parser = new OBOFormatParser();
                OBODoc doc = parser.parseURL(path);
                imports.add(doc);
            }
            obodoc.setImportedOBODocs(imports);
        }
        return obodoc;
    }

    public void parseOBODoc(@Nonnull OBODoc obodoc) {
        Frame h = new Frame(Frame.FrameType.HEADER);
        obodoc.setHeaderFrame(h);
        this.parseHeaderFrame(h);
        h.freeze();
        this.parseZeroOrMoreWsOptCmtNl();
        while (!this.stream.eof()) {
            this.parseEntityFrame(obodoc);
            this.parseZeroOrMoreWsOptCmtNl();
        }
        String defaultOboNamespace = h.getTagValue(OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE, String.class);
        if (defaultOboNamespace != null) {
            OBOFormatParser.addOboNamespace(obodoc.getTermFrames(), defaultOboNamespace);
            OBOFormatParser.addOboNamespace(obodoc.getTypedefFrames(), defaultOboNamespace);
            OBOFormatParser.addOboNamespace(obodoc.getInstanceFrames(), defaultOboNamespace);
        }
    }

    private static void addOboNamespace(@Nullable Collection<Frame> frames, String defaultOboNamespace) {
        if (frames != null && !frames.isEmpty()) {
            for (Frame termFrame : frames) {
                Clause clause = termFrame.getClause(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE);
                if (clause != null) continue;
                clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE, defaultOboNamespace);
                termFrame.addClause(clause);
            }
        }
    }

    @Nonnull
    public List<String> checkDanglingReferences(@Nonnull OBODoc doc) {
        String error;
        Clause c;
        ArrayList<String> danglingReferences = new ArrayList<String>();
        for (Frame f : doc.getTermFrames()) {
            for (String tag : f.getTags()) {
                OBOFormatConstants.OboFormatTag tagconstant = OBOFormatConstants.getTag(tag);
                c = f.getClause(tag);
                if (tagconstant != OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF && tagconstant != OBOFormatConstants.OboFormatTag.TAG_UNION_OF && tagconstant != OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO && tagconstant != OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM && tagconstant != OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP && tagconstant != OBOFormatConstants.OboFormatTag.TAG_IS_A) continue;
                if (c.getValues().size() > 1) {
                    error = this.checkRelation(c.getValue(String.class), tag, f.getId(), doc);
                    if (error != null) {
                        danglingReferences.add(error);
                    }
                    if ((error = this.checkClassReference(c.getValue2(String.class), tag, f.getId(), doc)) == null) continue;
                    danglingReferences.add(error);
                    continue;
                }
                error = this.checkClassReference(c.getValue(String.class), tag, f.getId(), doc);
                if (error == null) continue;
                danglingReferences.add(error);
            }
        }
        for (Frame f : doc.getTypedefFrames()) {
            for (String tag : f.getTags()) {
                OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
                c = f.getClause(tag);
                assert (c != null);
                if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_A || tagConstant == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF || tagConstant == OBOFormatConstants.OboFormatTag.TAG_UNION_OF || tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO || tagConstant == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM || tagConstant == OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF || tagConstant == OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER || tagConstant == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_OVER) {
                    error = this.checkRelation(c.getValue(String.class), tag, f.getId(), doc);
                    if (error == null) continue;
                    danglingReferences.add(error);
                    continue;
                }
                if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN || tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN || tagConstant == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
                    error = this.checkRelation(c.getValue().toString(), tag, f.getId(), doc);
                    if (error != null) {
                        danglingReferences.add(error);
                    }
                    if ((error = this.checkRelation(c.getValue2().toString(), tag, f.getId(), doc)) == null) continue;
                    danglingReferences.add(error);
                    continue;
                }
                if (tagConstant != OBOFormatConstants.OboFormatTag.TAG_DOMAIN && tagConstant != OBOFormatConstants.OboFormatTag.TAG_RANGE || (error = this.checkClassReference(c.getValue().toString(), tag, f.getId(), doc)) == null) continue;
                danglingReferences.add(error);
            }
        }
        return danglingReferences;
    }

    @Nullable
    private String checkRelation(String relId, String tag, String frameId, @Nonnull OBODoc doc) {
        if (doc.getTypedefFrame(relId, this.followImport) == null) {
            return "The relation '" + relId + "' reference in" + " the tag '" + tag + " ' in the frame of id '" + frameId + "' is not declared";
        }
        return null;
    }

    @Nullable
    private String checkClassReference(String classId, String tag, String frameId, @Nonnull OBODoc doc) {
        if (doc.getTermFrame(classId, this.followImport) == null) {
            return "The class '" + classId + "' reference in" + " the tag '" + tag + " ' in the frame of id '" + frameId + "'is not declared";
        }
        return null;
    }

    public void parseHeaderFrame(@Nonnull Frame h) {
        while (this.parseHeaderClauseNl(h)) {
        }
    }

    protected boolean parseHeaderClauseNl(@Nonnull Frame h) {
        this.parseZeroOrMoreWsOptCmtNl();
        if (this.stream.peekCharIs('[') || this.stream.eof()) {
            return false;
        }
        this.parseHeaderClause(h);
        this.parseHiddenComment();
        this.forceParseNlOrEof();
        return true;
    }

    protected void parseHeaderClause(@Nonnull Frame h) {
        String t = this.getParseTag();
        Clause cl = new Clause(t);
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        h.addClause(cl);
        if (tag == OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION) {
            this.parseUnquotedString(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION) {
            this.parseUnquotedString(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF) {
            this.parseSynonymTypedef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF) {
            this.parseSubsetdef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_DATE) {
            this.parseHeaderDate(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
            this.parsePropertyValue(cl);
            this.parseZeroOrMoreWs();
            this.parseQualifierBlock(cl);
            this.parseHiddenComment();
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IMPORT) {
            this.parseImport(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IDSPACE) {
            this.parseIdSpace(cl);
        } else {
            this.parseUnquotedString(cl);
        }
    }

    public void parseEntityFrame(@Nonnull OBODoc obodoc) {
        this.parseZeroOrMoreWsOptCmtNl();
        String rest = this.stream.rest();
        if (rest != null && rest.startsWith("[Term]")) {
            this.parseTermFrame(obodoc);
        } else if (rest != null && rest.startsWith("[Instance]")) {
            LOG.error("Error: Instance frames are not supported yet. Parsing stopped at line: " + this.stream.getLineNo());
            while (!this.stream.eof()) {
                this.stream.advanceLine();
            }
        } else {
            this.parseTypedefFrame(obodoc);
        }
    }

    public void parseTermFrame(@Nonnull OBODoc obodoc) {
        Frame f = new Frame(Frame.FrameType.TERM);
        this.parseZeroOrMoreWsOptCmtNl();
        if (this.stream.consume("[Term]")) {
            this.forceParseNlOrEof();
            this.parseIdLine(f);
            this.parseZeroOrMoreWsOptCmtNl();
            while (!this.stream.eof() && !this.stream.peekCharIs('[')) {
                this.parseTermFrameClauseEOL(f);
                this.parseZeroOrMoreWsOptCmtNl();
            }
            try {
                f.freeze();
                obodoc.addFrame(f);
            }
            catch (FrameMergeException e) {
                throw new OBOFormatParserException("Could not add frame " + f + " to document, duplicate frame definition?", (Throwable)e, this.stream.lineNo, this.stream.line);
            }
        } else {
            this.error("Expected a [Term] frame, but found unknown stanza type.");
        }
    }

    protected void parseTermFrameClauseEOL(@Nonnull Frame f) {
        if (this.stream.peekCharIs('!')) {
            this.parseHiddenComment();
            this.forceParseNlOrEof();
        } else {
            Clause cl = this.parseTermFrameClause();
            this.parseEOL(cl);
            f.addClause(cl);
        }
    }

    @Nonnull
    public Clause parseTermFrameClause() {
        Clause cl;
        String t = this.getParseTag();
        if (this.parseDeprecatedSynonym(t, cl = new Clause(t))) {
            return cl;
        }
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        if (tag == null) {
            this.error("Could not find tag for: " + t);
        }
        if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_NAME) {
            this.parseUnquotedString(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_NAMESPACE) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_ALT_ID) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_DEF) {
            this.parseDef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_COMMENT) {
            this.parseUnquotedString(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_SUBSET) {
            this.parseUnquotedString(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYM) {
            this.parseSynonym(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_XREF) {
            this.parseDirectXref(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_BUILTIN) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
            this.parsePropertyValue(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
            this.parseTermIntersectionOf(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            this.parseRelationship(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_CREATED_BY) {
            this.parsePerson(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE) {
            this.parseISODate(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_REPLACED_BY) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_CONSIDER) {
            this.parseIdRef(cl);
        } else {
            this.error("Unexpected tag " + (Object)((Object)tag) + " in term frame.");
        }
        return cl;
    }

    public void parseTypedefFrame(@Nonnull OBODoc obodoc) {
        Frame f = new Frame(Frame.FrameType.TYPEDEF);
        this.parseZeroOrMoreWsOptCmtNl();
        if (this.stream.consume("[Typedef]")) {
            this.forceParseNlOrEof();
            this.parseIdLine(f);
            this.parseZeroOrMoreWsOptCmtNl();
            while (!this.stream.eof() && !this.stream.peekCharIs('[')) {
                this.parseTypedefFrameClauseEOL(f);
                this.parseZeroOrMoreWsOptCmtNl();
            }
            try {
                f.freeze();
                obodoc.addFrame(f);
            }
            catch (FrameMergeException e) {
                throw new OBOFormatParserException("Could not add frame " + f + " to document, duplicate frame definition?", (Throwable)e, this.stream.lineNo, this.stream.line);
            }
        } else {
            this.error("Expected a [Typedef] frame, but found unknown stanza type.");
        }
    }

    protected void parseTypedefFrameClauseEOL(@Nonnull Frame f) {
        if (this.stream.peekCharIs('!')) {
            this.parseHiddenComment();
            this.forceParseNlOrEof();
        } else {
            Clause cl = this.parseTypedefFrameClause();
            this.parseEOL(cl);
            f.addClause(cl);
        }
    }

    @Nonnull
    public Clause parseTypedefFrameClause() {
        Clause cl;
        String t = this.getParseTag();
        if (t.equals("is_metadata")) {
            LOG.info("is_metadata DEPRECATED; switching to is_metadata_tag");
            t = OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag();
        }
        if (this.parseDeprecatedSynonym(t, cl = new Clause(t))) {
            return cl;
        }
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        if (tag == null) {
            this.error("Could not find tag for: " + t);
        }
        if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_NAME) {
            this.parseUnquotedString(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_NAMESPACE) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_ALT_ID) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_DEF) {
            this.parseDef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_COMMENT) {
            this.parseUnquotedString(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_SUBSET) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYM) {
            this.parseSynonym(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_XREF) {
            this.parseDirectXref(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
            this.parsePropertyValue(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_DOMAIN) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_RANGE) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_BUILTIN) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_ANTI_SYMMETRIC) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_CYCLIC) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_ASYMMETRIC) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
            this.parseTypedefIntersectionOf(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN) {
            this.parseIdRefPair(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN) {
            this.parseIdRefPair(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_OVER) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            this.parseRelationship(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_CREATED_BY) {
            this.parsePerson(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE) {
            this.parseISODate(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_REPLACED_BY) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_CONSIDER) {
            this.parseIdRef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG) {
            this.parseBoolean(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO) {
            this.parseOwlDef(cl);
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO) {
            this.parseOwlDef(cl);
        } else {
            this.error("Unexpected tag " + (Object)((Object)tag) + " in type def frame.");
        }
        return cl;
    }

    @Nonnull
    private String getParseTag() {
        int i;
        if (this.stream.eof()) {
            this.error("Expected an id tag, not end of file.");
        }
        if (this.stream.eol()) {
            this.error("Expected an id tag, not end of line");
        }
        if ((i = this.stream.indexOf(':')) == -1) {
            this.error("Could not find tag separator ':' in line.");
        }
        String tag = this.stream.rest().substring(0, i);
        this.stream.advance(i + 1);
        this.parseWs();
        this.parseZeroOrMoreWs();
        OBOFormatConstants.OboFormatTag formatTag = OBOFormatConstants.getTag(tag);
        if (formatTag != null) {
            tag = formatTag.getTag();
        }
        return OBOFormatParser.mapDeprecatedTag(tag);
    }

    private void parseIdRef(@Nonnull Clause cl) {
        this.parseIdRef(cl, false);
    }

    private void parseIdRef(@Nonnull Clause cl, boolean optional) {
        String id = this.getParseUntil(" !{");
        if (!optional && id.length() < 1) {
            this.error("");
        }
        cl.addValue(id);
    }

    private void parseIdRefPair(@Nonnull Clause cl) {
        this.parseIdRef(cl);
        this.parseOneOrMoreWs();
        this.parseIdRef(cl);
    }

    private void parsePerson(@Nonnull Clause cl) {
        this.parseUnquotedString(cl);
    }

    private boolean parseISODate(@Nonnull Clause cl) {
        String dateStr = this.getParseUntil(" !{");
        cl.setValue(dateStr);
        return true;
    }

    private void parseSubsetdef(@Nonnull Clause cl) {
        this.parseIdRef(cl);
        this.parseOneOrMoreWs();
        if (this.stream.consume("\"")) {
            String desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
        } else {
            this.error("");
        }
        this.parseZeroOrMoreWs();
        this.parseQualifierBlock(cl);
        this.parseHiddenComment();
    }

    private void parseSynonymTypedef(@Nonnull Clause cl) {
        this.parseIdRef(cl);
        this.parseOneOrMoreWs();
        if (this.stream.consume("\"")) {
            String desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
            if (this.stream.peekCharIs(' ')) {
                this.parseOneOrMoreWs();
                this.parseIdRef(cl, true);
            }
        }
        this.parseZeroOrMoreWs();
        this.parseQualifierBlock(cl);
        this.parseHiddenComment();
    }

    private void parseHeaderDate(@Nonnull Clause cl) {
        this.parseZeroOrMoreWs();
        String v = this.getParseUntil("!");
        v = OBOFormatParser.removeTrailingWS(v);
        try {
            Date date = OBOFormatConstants.headerDateFormat().parse(v);
            cl.addValue(date);
        }
        catch (ParseException e) {
            throw new OBOFormatParserException("Could not parse date from string: " + v, (Throwable)e, this.stream.lineNo, this.stream.line);
        }
    }

    private boolean parseImport(@Nonnull Clause cl) {
        this.parseZeroOrMoreWs();
        String v = this.getParseUntil("!{");
        v = OBOFormatParser.removeTrailingWS(v);
        cl.setValue(v);
        this.parseZeroOrMoreWs();
        if (this.stream.peekCharIs('{')) {
            this.getParseUntilAdv("}");
        }
        this.parseHiddenComment();
        return true;
    }

    private void parseIdSpace(@Nonnull Clause cl) {
        this.parseZeroOrMoreWs();
        this.parseIdRefPair(cl);
        this.parseZeroOrMoreWs();
        if (this.stream.peekCharIs('\"')) {
            this.stream.consume("\"");
            String desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
        } else {
            String desc = this.getParseUntil(" !{");
            cl.addValue(desc);
        }
        this.parseZeroOrMoreWs();
        this.parseQualifierBlock(cl);
        this.parseHiddenComment();
    }

    private void parseRelationship(@Nonnull Clause cl) {
        this.parseIdRef(cl);
        this.parseOneOrMoreWs();
        this.parseIdRef(cl);
    }

    private void parsePropertyValue(@Nonnull Clause cl) {
        String desc;
        if (this.stream.peekCharIs('\"')) {
            this.stream.consume("\"");
            desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
        } else {
            this.parseIdRef(cl);
        }
        this.parseOneOrMoreWs();
        if (this.stream.peekCharIs('\"')) {
            this.stream.consume("\"");
            desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
        } else {
            this.parseIdRef(cl);
        }
        this.parseZeroOrMoreWs();
        String s = this.getParseUntil(" !{");
        if (!s.isEmpty()) {
            cl.addValue(s);
        }
    }

    private void parseTermIntersectionOf(@Nonnull Clause cl) {
        char c;
        this.parseIdRef(cl);
        this.parseZeroOrMoreWs();
        if (!this.stream.eol() && (c = this.stream.peekChar()) != '!' && c != '{') {
            this.parseIdRef(cl, true);
        }
    }

    private void parseTypedefIntersectionOf(@Nonnull Clause cl) {
        this.parseIdRef(cl);
    }

    private boolean parseDeprecatedSynonym(@Nonnull String tag, @Nonnull Clause cl) {
        String scope = null;
        if (tag.equals("exact_synonym")) {
            scope = OBOFormatConstants.OboFormatTag.TAG_EXACT.getTag();
        } else if (tag.equals("narrow_synonym")) {
            scope = OBOFormatConstants.OboFormatTag.TAG_NARROW.getTag();
        } else if (tag.equals("broad_synonym")) {
            scope = OBOFormatConstants.OboFormatTag.TAG_BROAD.getTag();
        } else if (tag.equals("related_synonym")) {
            scope = OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag();
        } else {
            return false;
        }
        cl.setTag(OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag());
        if (this.stream.consume("\"")) {
            String syn = this.getParseUntilAdv("\"");
            cl.setValue(syn);
            cl.addValue(scope);
            this.parseZeroOrMoreWs();
            this.parseXrefList(cl, false);
            return true;
        }
        return false;
    }

    private void parseSynonym(@Nonnull Clause cl) {
        if (this.stream.consume("\"")) {
            String syn = this.getParseUntilAdv("\"");
            cl.setValue(syn);
            this.parseZeroOrMoreWs();
            if (!this.stream.peekCharIs('[')) {
                this.parseIdRef(cl, true);
                this.parseZeroOrMoreWs();
                if (!this.stream.peekCharIs('[')) {
                    this.parseIdRef(cl, true);
                    this.parseZeroOrMoreWs();
                }
            }
            this.parseXrefList(cl, false);
        } else {
            this.error("The synonym is always a quoted string.");
        }
    }

    private void parseDef(@Nonnull Clause cl) {
        if (this.stream.consume("\"")) {
            String def = this.getParseUntilAdv("\"");
            cl.setValue(def);
            this.parseZeroOrMoreWs();
            this.parseXrefList(cl, true);
        } else {
            this.error("Definitions should always be a quoted string.");
        }
    }

    private void parseOwlDef(@Nonnull Clause cl) {
        if (this.stream.consume("\"")) {
            String def = this.getParseUntilAdv("\"");
            cl.setValue(def);
            this.parseZeroOrMoreWs();
            this.parseXrefList(cl, true);
        } else {
            this.error("The " + cl.getTag() + " clause is always a quoted string.");
        }
    }

    private void parseXrefList(@Nonnull Clause cl, boolean optional) {
        if (this.stream.consume("[")) {
            this.parseZeroOrMoreXrefs(cl);
            this.parseZeroOrMoreWs();
            if (!this.stream.consume("]")) {
                this.error("Missing closing ']' for xref list at pos: " + this.stream.pos);
            }
        } else if (!optional) {
            this.error("Clause: " + cl.getTag() + "; expected an xref list, or at least an empty list '[]' at pos: " + this.stream.pos);
        }
    }

    private boolean parseZeroOrMoreXrefs(@Nonnull Clause cl) {
        if (this.parseXref(cl)) {
            while (this.stream.consume(",") && this.parseXref(cl)) {
            }
        }
        return true;
    }

    private boolean parseXref(@Nonnull Clause cl) {
        this.parseZeroOrMoreWs();
        String id = this.getParseUntil("\",]!{", true);
        if (!id.isEmpty()) {
            if ((id = OBOFormatParser.removeTrailingWS(id)).contains(" ")) {
                this.warn("accepting bad xref with spaces:" + id);
            }
            Xref xref = new Xref(id);
            cl.addXref(xref);
            this.parseZeroOrMoreWs();
            if (this.stream.peekCharIs('\"')) {
                this.stream.consume("\"");
                xref.setAnnotation(this.getParseUntilAdv("\""));
            }
            return true;
        }
        return false;
    }

    private boolean parseDirectXref(@Nonnull Clause cl) {
        this.parseZeroOrMoreWs();
        String id = this.getParseUntil("\",]!{", true);
        id = id.trim();
        if (id.contains(" ")) {
            this.warn("accepting bad xref with spaces:<" + id + '>');
        }
        id = id.replaceAll(" +\\Z", "");
        Xref xref = new Xref(id);
        cl.addValue(xref);
        this.parseZeroOrMoreWs();
        if (this.stream.peekCharIs('\"')) {
            this.stream.consume("\"");
            xref.setAnnotation(this.getParseUntilAdv("\""));
        }
        return true;
    }

    private void parseQualifierBlock(@Nonnull Clause cl) {
        if (this.stream.consume("{")) {
            this.parseZeroOrMoreQuals(cl);
            this.parseZeroOrMoreWs();
            boolean success = this.stream.consume("}");
            if (!success) {
                this.error("Missing closing '}' for trailing qualifier block.");
            }
        }
    }

    private void parseZeroOrMoreQuals(@Nonnull Clause cl) {
        if (this.parseQual(cl)) {
            while (this.stream.consume(",") && this.parseQual(cl)) {
            }
        }
    }

    private boolean parseQual(@Nonnull Clause cl) {
        String v;
        this.parseZeroOrMoreWs();
        String rest = this.stream.rest();
        assert (rest != null);
        if (!rest.contains("=")) {
            this.error("Missing '=' in trailing qualifier block. This might happen for not properly escaped '{', '}' chars in comments.");
        }
        String q = this.getParseUntilAdv("=");
        this.parseZeroOrMoreWs();
        if (this.stream.consume("\"")) {
            v = this.getParseUntilAdv("\"");
        } else {
            v = this.getParseUntil(" ,}");
            this.warn("qualifier values should be enclosed in quotes. You have: " + q + '=' + this.stream.rest());
        }
        if (v.isEmpty()) {
            this.warn("Empty value for qualifier in trailing qualifier block.");
            v = "";
        }
        QualifierValue qv = new QualifierValue(q, v);
        cl.addQualifierValue(qv);
        this.parseZeroOrMoreWs();
        return true;
    }

    private void parseBoolean(@Nonnull Clause cl) {
        if (this.stream.consume("true")) {
            cl.setValue(true);
        } else if (this.stream.consume("false")) {
            cl.setValue(false);
        } else {
            this.error("Could not parse boolean value.");
        }
    }

    protected void parseIdLine(@Nonnull Frame f) {
        String t = this.getParseTag();
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        if (tag != OBOFormatConstants.OboFormatTag.TAG_ID) {
            this.error("Expected id tag as first line in frame, but was: " + (Object)((Object)tag));
        }
        Clause cl = new Clause(t);
        f.addClause(cl);
        String id = this.getParseUntil(" !{");
        if (id.isEmpty()) {
            this.error("Could not find an valid id, id is empty.");
        }
        cl.addValue(id);
        f.setId(id);
        this.parseEOL(cl);
    }

    public void parseEOL(@Nonnull Clause cl) {
        this.parseZeroOrMoreWs();
        this.parseQualifierBlock(cl);
        this.parseHiddenComment();
        this.forceParseNlOrEof();
    }

    private void parseHiddenComment() {
        this.parseZeroOrMoreWs();
        if (this.stream.peekCharIs('!')) {
            this.stream.forceEol();
        }
    }

    protected void parseUnquotedString(@Nonnull Clause cl) {
        this.parseZeroOrMoreWs();
        String v = this.getParseUntil("!{");
        v = OBOFormatParser.removeTrailingWS(v);
        cl.setValue(v);
        if (this.stream.peekCharIs('{')) {
            this.parseQualifierBlock(cl);
        }
        this.parseHiddenComment();
    }

    protected void forceParseNlOrEof() {
        this.parseZeroOrMoreWs();
        if (this.stream.eol()) {
            this.stream.advanceLine();
            return;
        }
        if (this.stream.eof()) {
            return;
        }
        this.error("expected newline or end of line but found: " + this.stream.rest());
    }

    protected void parseZeroOrMoreWsOptCmtNl() {
        while (true) {
            this.parseZeroOrMoreWs();
            this.parseHiddenComment();
            if (!this.stream.eol()) break;
            this.stream.advanceLine();
        }
    }

    protected void parseWs() {
        if (this.stream.eol()) {
            this.error("Expected at least one white space, but found end of line at pos: " + this.stream.pos);
        }
        if (this.stream.eof()) {
            this.error("Expected at least one white space, but found end of file.");
        }
        if (this.stream.peekChar() == ' ') {
            this.stream.advance(1);
        } else {
            this.warn("Expected white space at pos: " + this.stream.pos);
        }
    }

    protected void parseOneOrMoreWs() {
        if (this.stream.eol() || this.stream.eof()) {
            this.error("Expected at least one white space at pos: " + this.stream.pos);
        }
        int n = 0;
        while (this.stream.peekCharIs(' ')) {
            this.stream.advance(1);
            ++n;
        }
        if (n == 0) {
            this.error("Expected at least one white space at pos: " + this.stream.pos);
        }
    }

    protected void parseZeroOrMoreWs() {
        if (!this.stream.eol() && !this.stream.eof()) {
            while (this.stream.peekCharIs(' ')) {
                this.stream.advance(1);
            }
        }
    }

    @Nonnull
    private String getParseUntilAdv(@Nonnull String compl) {
        String ret = this.getParseUntil(compl);
        this.stream.advance(1);
        return ret;
    }

    @Nonnull
    private String getParseUntil(@Nonnull String compl) {
        return this.getParseUntil(compl, false);
    }

    @Nonnull
    private String getParseUntil(@Nonnull String compl, boolean commaWhitespace) {
        String r = this.stream.rest();
        assert (r != null);
        int i = 0;
        boolean hasEscapedChars = false;
        while (i < r.length()) {
            if (r.charAt(i) == '\\') {
                hasEscapedChars = true;
                i += 2;
                continue;
            }
            if (compl.contains(r.subSequence(i, i + 1)) && (!commaWhitespace || r.charAt(i) != ',' || i + 1 < r.length() && r.charAt(i + 1) == ' ')) break;
            ++i;
        }
        if (i == 0) {
            return "";
        }
        String ret = r.substring(0, i);
        if (hasEscapedChars) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < ret.length(); ++j) {
                char c = ret.charAt(j);
                if (c == '\\') {
                    int next = j + 1;
                    if (next >= ret.length()) continue;
                    char nextChar = ret.charAt(next);
                    switch (nextChar) {
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'W': {
                            sb.append(' ');
                            break;
                        }
                        case 't': {
                            sb.append('\n');
                            break;
                        }
                        default: {
                            sb.append(nextChar);
                        }
                    }
                    ++j;
                    continue;
                }
                sb.append(c);
            }
            ret = sb.toString();
        }
        this.stream.advance(i);
        String cachedValue = (String)this.stringCache.getUnchecked((Object)ret);
        if (LOG.isTraceEnabled() && ret != cachedValue) {
            LOG.trace("Cache hit for  {}", (Object)cachedValue);
        }
        return cachedValue;
    }

    @Nonnull
    private static String mapDeprecatedTag(@Nonnull String tag) {
        if (tag.equals("inverse_of_on_instance_level")) {
            return OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag();
        }
        if (tag.equals("xref_analog")) {
            return OBOFormatConstants.OboFormatTag.TAG_XREF.getTag();
        }
        if (tag.equals("xref_unknown")) {
            return OBOFormatConstants.OboFormatTag.TAG_XREF.getTag();
        }
        if (tag.equals("instance_level_is_transitive")) {
            return OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE.getTag();
        }
        return tag;
    }

    private static String removeTrailingWS(@Nonnull String s) {
        return s.replaceAll("\\s*$", "");
    }

    private void error(String message) {
        throw new OBOFormatParserException(message, this.stream.lineNo, this.stream.line);
    }

    private void warn(String message) {
        LOG.warn("LINE: {} {}  LINE:\n{}", new Object[]{this.stream.lineNo, message, this.stream.line});
    }

    protected static class MyStream {
        int pos = 0;
        String line;
        int lineNo = 0;
        BufferedReader reader;

        public MyStream() {
            this.pos = 0;
        }

        public MyStream(BufferedReader r) {
            this.reader = r;
        }

        protected char peekChar() {
            this.prepare();
            return this.line.charAt(this.pos);
        }

        public char nextChar() {
            ++this.pos;
            return this.line.charAt(this.pos - 1);
        }

        @Nullable
        public String rest() {
            this.prepare();
            if (this.line == null) {
                return null;
            }
            if (this.pos >= this.line.length()) {
                return "";
            }
            return this.line.substring(this.pos);
        }

        public void advance(int dist) {
            this.pos += dist;
        }

        public void prepare() {
            if (this.line == null) {
                this.advanceLine();
            }
        }

        public void advanceLine() {
            try {
                this.line = this.reader.readLine();
                ++this.lineNo;
                this.pos = 0;
            }
            catch (IOException e) {
                throw new OBOFormatParserException((Throwable)e, this.lineNo, "Error reading from input.");
            }
        }

        public void forceEol() {
            if (this.line == null) {
                return;
            }
            this.pos = this.line.length();
        }

        public boolean eol() {
            this.prepare();
            if (this.line == null) {
                return false;
            }
            return this.pos >= this.line.length();
        }

        public boolean eof() {
            this.prepare();
            return this.line == null;
        }

        @Nonnull
        public static String getTag() {
            return "";
        }

        public boolean consume(@Nonnull String s) {
            String r = this.rest();
            if (r == null) {
                return false;
            }
            if (r.startsWith(s)) {
                this.pos += s.length();
                return true;
            }
            return false;
        }

        public int indexOf(char c) {
            this.prepare();
            if (this.line == null) {
                return -1;
            }
            return this.line.substring(this.pos).indexOf(c);
        }

        @Nonnull
        public String toString() {
            return this.line + "//" + this.pos + " LINE:" + this.lineNo;
        }

        public boolean peekCharIs(char c) {
            if (this.eol() || this.eof()) {
                return false;
            }
            return this.peekChar() == c;
        }

        public int getLineNo() {
            return this.lineNo;
        }
    }
}

