/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.AnonId;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.riot.lang.BlankNodeAllocator;
import org.apache.jena.riot.lang.BlankNodeAllocatorHash;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.MapWithScope;

public class LabelToNode
extends MapWithScope<String, Node, Node> {
    private static MapWithScope.Allocator<String, Node> nodeMaker = new MapWithScope.Allocator<String, Node>(){

        @Override
        public Node alloc(String label) {
            return this.create();
        }

        @Override
        public Node create() {
            return NodeFactory.createAnon();
        }

        @Override
        public void reset() {
        }
    };
    private static MapWithScope.Allocator<String, Node> nodeMakerDeterministic = new MapWithScope.Allocator<String, Node>(){
        private AtomicLong counter = new AtomicLong(0L);

        @Override
        public Node alloc(String label) {
            return this.create();
        }

        @Override
        public Node create() {
            String $ = String.format("B0x%04X", this.counter.incrementAndGet());
            return NodeFactory.createAnon((AnonId)new AnonId($));
        }

        @Override
        public void reset() {
        }
    };
    private static MapWithScope.Allocator<String, Node> nodeMakerByLabel = new MapWithScope.Allocator<String, Node>(){
        private AtomicLong counter = new AtomicLong(0L);

        @Override
        public Node alloc(String label) {
            return NodeFactory.createAnon((AnonId)new AnonId(label));
        }

        @Override
        public Node create() {
            return this.alloc("genid" + this.counter.getAndIncrement());
        }

        @Override
        public void reset() {
        }
    };
    private static MapWithScope.Allocator<String, Node> nodeMakerByLabelEncoded = new MapWithScope.Allocator<String, Node>(){
        private AtomicLong counter = new AtomicLong(0L);

        @Override
        public Node alloc(String label) {
            return NodeFactory.createAnon((AnonId)new AnonId(NodeFmtLib.decodeBNodeLabel(label)));
        }

        @Override
        public Node create() {
            return this.alloc("genid" + this.counter.getAndIncrement());
        }

        @Override
        public void reset() {
        }
    };

    public static LabelToNode createScopeByDocument() {
        return new LabelToNode(new SingleScopePolicy(), nodeMaker);
    }

    public static LabelToNode createScopeByDocumentHash() {
        return new LabelToNode(new AllocScopePolicy(), new AllocNodeHash());
    }

    public static LabelToNode createScopeByGraph() {
        return new LabelToNode(new GraphScopePolicy(), nodeMaker);
    }

    public static LabelToNode createUseLabelAsGiven() {
        return new LabelToNode(new AllocScopePolicy(), nodeMakerByLabel);
    }

    public static LabelToNode createUseLabelEncoded() {
        return new LabelToNode(new AllocScopePolicy(), nodeMakerByLabelEncoded);
    }

    public static LabelToNode createIncremental() {
        return new LabelToNode(new SingleScopePolicy(), nodeMakerDeterministic);
    }

    public LabelToNode(MapWithScope.ScopePolicy<String, Node, Node> scopePolicy, MapWithScope.Allocator<String, Node> allocator) {
        super(scopePolicy, allocator);
    }

    private static class AllocNodeHash
    implements MapWithScope.Allocator<String, Node> {
        private BlankNodeAllocator alloc = new BlankNodeAllocatorHash();

        private AllocNodeHash() {
        }

        @Override
        public Node alloc(String label) {
            return this.alloc.alloc(label);
        }

        @Override
        public Node create() {
            return this.alloc.create();
        }

        @Override
        public void reset() {
            this.alloc.reset();
        }
    }

    private static class AllocScopePolicy
    implements MapWithScope.ScopePolicy<String, Node, Node> {
        private AllocScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            return null;
        }

        @Override
        public void clear() {
        }
    }

    private static class GraphScopePolicy
    implements MapWithScope.ScopePolicy<String, Node, Node> {
        private Map<String, Node> dftMap = new HashMap<String, Node>();
        private Map<Node, Map<String, Node>> map = new HashMap<Node, Map<String, Node>>();

        private GraphScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            if (scope == null) {
                return this.dftMap;
            }
            Map<String, Node> x = this.map.get(scope);
            if (x == null) {
                x = new HashMap<String, Node>();
                this.map.put(scope, x);
            }
            return x;
        }

        @Override
        public void clear() {
            this.dftMap.clear();
            this.map.clear();
        }
    }

    private static class SingleScopePolicy
    implements MapWithScope.ScopePolicy<String, Node, Node> {
        private Map<String, Node> map = new HashMap<String, Node>();

        private SingleScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            return this.map;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

