/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.pellet.owlapiv3.LimitedMapIRIMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.utils.FileUtils;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWL2Profile;
import org.semanticweb.owlapi.profiles.OWL2QLProfile;
import org.semanticweb.owlapi.profiles.OWL2RLProfile;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.util.DLExpressivityChecker;
import org.semanticweb.owlapi.util.NonMappingOntologyIRIMapper;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletInfo
extends PelletCmdApp {
    private final List<OWLProfile> profiles = Arrays.asList(new OWL2ELProfile(), new OWL2QLProfile(), new OWL2RLProfile(), new OWL2DLProfile(), new OWL2Profile());

    @Override
    public String getAppCmd() {
        return "pellet info " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public String getAppId() {
        return "PelletInfo: Display information and statistics about 1 or more ontologies";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        PelletCmdOption helpOption = new PelletCmdOption("help");
        helpOption.setShortOption("h");
        helpOption.setDescription("Print this message");
        helpOption.setDefaultValue(false);
        helpOption.setIsMandatory(false);
        helpOption.setArg(PelletCmdOptionArg.NONE);
        options.add(helpOption);
        PelletCmdOption verboseOption = new PelletCmdOption("verbose");
        verboseOption.setShortOption("v");
        verboseOption.setDescription("More verbose output");
        verboseOption.setDefaultValue(false);
        verboseOption.setIsMandatory(false);
        verboseOption.setArg(PelletCmdOptionArg.NONE);
        options.add(verboseOption);
        PelletCmdOption configOption = new PelletCmdOption("config");
        configOption.setShortOption("C");
        configOption.setDescription("Use the selected configuration file");
        configOption.setIsMandatory(false);
        configOption.setType("configuration file");
        configOption.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(configOption);
        PelletCmdOption option = new PelletCmdOption("merge");
        option.setShortOption("m");
        option.setDescription("Merge the ontologies");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        options.add(this.getIgnoreImportsOption());
        return options;
    }

    @Override
    public void run() {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            Collection inputFiles = FileUtils.getFileURIs((String[])this.getInputFiles());
            LimitedMapIRIMapper iriMapper = new LimitedMapIRIMapper();
            OWLOntology baseOntology = manager.createOntology();
            manager.clearIRIMappers();
            if (this.options.getOption("ignore-imports").getValueAsBoolean()) {
                manager.addIRIMapper((OWLOntologyIRIMapper)iriMapper);
                manager.setOntologyLoaderConfiguration(manager.getOntologyLoaderConfiguration().setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT));
            } else {
                manager.addIRIMapper((OWLOntologyIRIMapper)new NonMappingOntologyIRIMapper());
                manager.setOntologyLoaderConfiguration(manager.getOntologyLoaderConfiguration().setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT));
            }
            if (inputFiles.size() > 1) {
                for (String inputFile : inputFiles) {
                    this.addFile(inputFile, manager, iriMapper, baseOntology);
                }
            } else {
                this.addSingleFile((String)inputFiles.iterator().next(), manager, iriMapper);
            }
            manager.removeOntology(baseOntology);
            if (this.options.getOption("merge").getValueAsBoolean()) {
                manager = this.mergeOntologiesInNewManager(manager);
            }
            this.printStats(manager);
        }
        catch (Exception e) {
            throw new PelletCmdException(e);
        }
    }

    private void addFile(String inputFile, OWLOntologyManager manager, LimitedMapIRIMapper iriMapper, OWLOntology baseOntology) {
        block2: {
            try {
                IRI iri = IRI.create((String)inputFile);
                iriMapper.addAllowedIRI(iri);
                OWLImportsDeclaration declaration = manager.getOWLDataFactory().getOWLImportsDeclaration(iri);
                manager.applyChange((OWLOntologyChange)new AddImport(baseOntology, declaration));
                manager.makeLoadImportRequest(declaration);
            }
            catch (Exception e) {
                if (!this.verbose) break block2;
                System.err.println(e.getLocalizedMessage());
            }
        }
    }

    private void addSingleFile(String inputFile, OWLOntologyManager manager, LimitedMapIRIMapper iriMapper) {
        block2: {
            try {
                IRI iri = IRI.create((String)inputFile);
                iriMapper.addAllowedIRI(iri);
                manager.loadOntologyFromOntologyDocument(iri);
            }
            catch (Exception e) {
                if (!this.verbose) break block2;
                System.err.println(e.getLocalizedMessage());
            }
        }
    }

    private OWLOntologyManager mergeOntologiesInNewManager(OWLOntologyManager manager) throws OWLOntologyCreationException {
        OWLOntologyManager newManager = OWLManager.createOWLOntologyManager();
        OWLOntology merged = newManager.createOntology();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLOntology ontology : manager.getOntologies()) {
            for (OWLAxiom ax : ontology.getAxioms()) {
                changes.add(new AddAxiom(merged, ax));
            }
        }
        newManager.applyChanges(changes);
        return newManager;
    }

    private void printStats(OWLOntologyManager manager) {
        for (OWLOntology ontology : manager.getOntologies()) {
            String ontologyLocation = manager.getOntologyDocumentIRI(ontology) != null ? manager.getOntologyDocumentIRI(ontology).toString() : "ontology";
            String ontologyBaseURI = ontology.getOntologyID().getOntologyIRI().isPresent() ? ((IRI)ontology.getOntologyID().getOntologyIRI().get()).toQuotedString() : "";
            this.output("Information about " + ontologyLocation + " (" + ontologyBaseURI + ")");
            if (this.verbose) {
                this.printOntologyHeader(ontology);
            }
            DLExpressivityChecker expressivityChecker = new DLExpressivityChecker(Collections.singleton(ontology));
            this.output("OWL Profile = " + this.getProfile(ontology));
            this.output("DL Expressivity = " + expressivityChecker.getDescriptionLogicName());
            this.output("Axioms = " + ontology.getAxiomCount());
            this.output("Logical Axioms = " + ontology.getLogicalAxiomCount());
            this.output("GCI Axioms = " + ontology.getGeneralClassAxioms().size());
            this.output("Individuals = " + ontology.getIndividualsInSignature().size());
            this.output("Classes = " + ontology.getClassesInSignature().size());
            this.output("Object Properties = " + ontology.getObjectPropertiesInSignature().size());
            this.output("Data Properties = " + ontology.getDataPropertiesInSignature().size());
            this.output("Annotation Properties = " + ontology.getAnnotationPropertiesInSignature().size());
            Set imports = ontology.getImportsDeclarations();
            if (imports.size() > 0) {
                this.output("Direct Imports:");
                int count = 1;
                for (OWLImportsDeclaration imp : imports) {
                    this.output(count + ": " + imp.getIRI().toString());
                }
                ++count;
            }
            this.output("");
        }
    }

    private String getProfile(OWLOntology ontology) {
        for (OWLProfile profile : this.profiles) {
            if (!profile.checkOntology(ontology).isInProfile()) continue;
            return profile.getName();
        }
        return "Unknown Profile";
    }

    private void printOntologyHeader(OWLOntology ontology) {
        for (OWLAnnotation annotation : ontology.getAnnotations()) {
            IRI property = annotation.getProperty().getIRI();
            OWLAnnotationValue value = annotation.getValue();
            if (property.equals((Object)OWLRDFVocabulary.OWL_VERSION_INFO.getIRI())) {
                this.verbose("Version Info = " + this.getString(value));
                continue;
            }
            if (property.equals((Object)OWLRDFVocabulary.OWL_PRIOR_VERSION.getIRI())) {
                this.verbose("Prior Version Info = " + this.getString(value));
                continue;
            }
            if (property.equals((Object)OWLRDFVocabulary.OWL_BACKWARD_COMPATIBLE_WITH.getIRI())) {
                this.verbose("Backward Compatible With = " + this.getString(value));
                continue;
            }
            if (!property.equals((Object)OWLRDFVocabulary.OWL_INCOMPATIBLE_WITH.getIRI())) continue;
            this.verbose("Incompatible With = " + this.getString(value));
        }
    }

    private String getString(OWLAnnotationValue value) {
        if (value instanceof OWLLiteral) {
            return ((OWLLiteral)value).getLiteral();
        }
        return value.toString();
    }
}

