/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.testing.dbunit;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.AbstractOperation;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.ExclusiveTransactionException;

public class MySqlAbstractNoFkOperation
extends AbstractOperation {
    private final DatabaseOperation operation;

    public MySqlAbstractNoFkOperation(DatabaseOperation operation) {
        this.operation = operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        Connection jdbcConnection = connection.getConnection();
        Statement statement = jdbcConnection.createStatement();
        try {
            if (!jdbcConnection.getAutoCommit()) {
                throw new ExclusiveTransactionException();
            }
            jdbcConnection.setAutoCommit(false);
            statement.execute("SET FOREIGN_KEY_CHECKS=0");
            try {
                this.operation.execute(connection, connection.createDataSet());
            }
            finally {
                statement.execute("SET FOREIGN_KEY_CHECKS=1");
                jdbcConnection.commit();
            }
        }
        finally {
            jdbcConnection.setAutoCommit(true);
            statement.close();
        }
    }
}

