/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.testing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.xml.XmlDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbUnitUtils {
    private static Logger log = LoggerFactory.getLogger(DbUnitUtils.class);

    private DbUnitUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportDataset(IDatabaseConnection connection, String[] tableNames, File file) throws SQLException, IOException, DataSetException {
        OutputStream fos = null;
        try {
            IDataSet fullDataSet = connection.createDataSet();
            if (tableNames != null && tableNames.length > 0) {
                fullDataSet = new FilteredDataSet(tableNames, fullDataSet);
            }
            fos = new FileOutputStream(file);
            if (StringUtils.equalsIgnoreCase((String)StringUtils.substringAfterLast((String)file.getName(), (String)"."), (String)"xls")) {
                XlsDataSet.write((IDataSet)fullDataSet, (OutputStream)fos);
            } else {
                XmlDataSet.write((IDataSet)fullDataSet, (OutputStream)fos);
            }
        }
        finally {
            fos.close();
        }
        log.debug("Dataset exported at {}", (Object)file.getAbsolutePath());
    }

    public void exportTablesToDir(IDatabaseConnection connection, File directory, boolean xls, ITableFilter tableFilter) throws SQLException, DataSetException, IOException {
        String[] tablenames;
        directory.mkdirs();
        IDataSet dataset = connection.createDataSet();
        if (tableFilter != null) {
            dataset = new FilteredDataSet(tableFilter, dataset);
        }
        for (String table : tablenames = dataset.getTableNames()) {
            File exportFile = new File(directory, table + (xls ? ".xls" : ".xml"));
            log.info("Exporting {}", (Object)table);
            DbUnitUtils.exportDataset(connection, new String[]{table}, exportFile);
        }
    }

    public static IDataSet loadDataset(URL url) throws IOException, DataSetException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        InputStream is = url.openStream();
        XlsDataSet dataSet = null;
        if (is != null) {
            log.debug("loading dataset {}", (Object)url.getFile());
            dataSet = url.getFile().endsWith(".xls") ? new XlsDataSet(is) : new XmlDataSet(is);
            is.close();
        }
        return dataSet;
    }
}

