/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.testing;

import it.openutils.testing.DbUnitConfiguration;
import it.openutils.testing.DbUnitExecution;
import it.openutils.testing.DbUnitUtils;
import it.openutils.testing.RegExpTableFilter;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableFilter;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.DeleteAllOperation;
import org.dbunit.operation.DeleteOperation;
import org.dbunit.operation.InsertOperation;
import org.dbunit.operation.RefreshOperation;
import org.dbunit.operation.TruncateTableOperation;
import org.dbunit.operation.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUnitTestContext {
    protected static Map<String, IDataSet> truncateDataSetCache = new HashMap<String, IDataSet>();
    private static Logger log = LoggerFactory.getLogger(DbUnitTestContext.class);
    private Object testcase;
    private ApplicationContext applicationContext;
    private Map<String, IDataSet> datasetCache = new HashMap<String, IDataSet>();

    public DbUnitTestContext(Object testcase, ApplicationContext applicationContext) {
        this.testcase = testcase;
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpDbUnit() throws Exception {
        DbUnitExecution singleDbUnitExecution = this.testcase.getClass().getAnnotation(DbUnitExecution.class);
        DbUnitExecution[] executions = null;
        if (singleDbUnitExecution != null) {
            executions = new DbUnitExecution[]{singleDbUnitExecution};
        } else {
            DbUnitConfiguration dbUnitConfiguration = this.testcase.getClass().getAnnotation(DbUnitConfiguration.class);
            if (dbUnitConfiguration != null) {
                executions = dbUnitConfiguration.dbUnitExecutions();
            }
        }
        if (executions != null) {
            for (DbUnitExecution dbUnitExecution : executions) {
                String[] datasets = dbUnitExecution.datasets();
                String dataSourceName = dbUnitExecution.dataSource();
                String schema = dbUnitExecution.schema();
                if (StringUtils.isEmpty((String)schema)) {
                    schema = null;
                }
                DatabaseConnection connection = new DatabaseConnection(this.getDatasource(dataSourceName).getConnection(), schema);
                try {
                    RegExpTableFilter tableFilter = new RegExpTableFilter(dbUnitExecution.excludedTables());
                    if (dbUnitExecution.truncateAll()) {
                        this.truncateAll((IDatabaseConnection)connection, (ITableFilter)tableFilter, dataSourceName, this.getDatabaseOperation(dbUnitExecution.truncateOperation()));
                    }
                    DatabaseOperation dbOperation = this.getDatabaseOperation(dbUnitExecution.insertOperation());
                    for (String datasetFile : datasets) {
                        this.importDataSet(this.createDataset(datasetFile), (IDatabaseConnection)connection, (ITableFilter)tableFilter, dataSourceName, dbOperation);
                    }
                }
                finally {
                    connection.close();
                }
            }
        }
    }

    private DatabaseOperation getDatabaseOperation(Class<? extends DatabaseOperation> dboperationClass) throws InstantiationException, IllegalAccessException {
        if (UpdateOperation.class.equals(dboperationClass)) {
            return DatabaseOperation.UPDATE;
        }
        if (InsertOperation.class.equals(dboperationClass)) {
            return DatabaseOperation.INSERT;
        }
        if (RefreshOperation.class.equals(dboperationClass)) {
            return DatabaseOperation.REFRESH;
        }
        if (DeleteOperation.class.equals(dboperationClass)) {
            return DatabaseOperation.DELETE;
        }
        if (DeleteAllOperation.class.equals(dboperationClass)) {
            return DatabaseOperation.DELETE_ALL;
        }
        if (TruncateTableOperation.class.equals(dboperationClass)) {
            return DatabaseOperation.TRUNCATE_TABLE;
        }
        if (DeleteOperation.class.equals(dboperationClass)) {
            return DatabaseOperation.UPDATE;
        }
        return dboperationClass.newInstance();
    }

    private IDataSet createDataset(String datasetFile) throws IOException, DataSetException {
        IDataSet dataSet = this.datasetCache.get(datasetFile);
        if (dataSet == null) {
            URL datasetUrl = this.getClass().getResource(datasetFile);
            if (datasetUrl == null) {
                throw new IllegalArgumentException("Dataset " + datasetFile + " not found");
            }
            dataSet = DbUnitUtils.loadDataset(datasetUrl);
            this.datasetCache.put(datasetFile, dataSet);
        }
        return dataSet;
    }

    private void importDataSet(IDataSet dataSet, IDatabaseConnection connection, ITableFilter tableFilter, String dataSourceName, DatabaseOperation databaseOperation) throws SQLException, DataSetException, DatabaseUnitException {
        IDataSet truncateDataSet;
        if (dataSet == null) {
            throw new IllegalArgumentException("dataSet is null");
        }
        FilteredDataSet orderedDataset = new FilteredDataSet(tableFilter, dataSet);
        if (log.isDebugEnabled()) {
            log.debug("Tables: {}", (Object)ArrayUtils.toString((Object)orderedDataset.getTableNames()));
        }
        if ((truncateDataSet = this.getTruncateDataset(dataSourceName, connection.getSchema())) != null) {
            SequenceTableFilter filter = new SequenceTableFilter(truncateDataSet.getTableNames());
            orderedDataset = new FilteredDataSet((ITableFilter)filter, dataSet);
        }
        if (dataSet != null) {
            databaseOperation.execute(connection, (IDataSet)orderedDataset);
        }
    }

    private void truncateAll(IDatabaseConnection connection, ITableFilter tableFilter, String dataSourceName, DatabaseOperation databaseOperation) throws SQLException, DataSetException, DatabaseUnitException {
        IDataSet truncateDataSet = this.getTruncateDataset(dataSourceName, connection.getSchema());
        if (truncateDataSet == null) {
            log.debug("Generating sorted dataset for initial cleanup");
            IDataSet unsortedDataSet = connection.createDataSet();
            if (log.isDebugEnabled()) {
                log.debug("Unfiltered truncateDataSet: {}", (Object)ArrayUtils.toString((Object)unsortedDataSet.getTableNames()));
            }
            unsortedDataSet = new FilteredDataSet(tableFilter, unsortedDataSet);
            DatabaseSequenceFilter sortingFilter = new DatabaseSequenceFilter(connection, unsortedDataSet.getTableNames());
            truncateDataSet = new FilteredDataSet((ITableFilter)sortingFilter, unsortedDataSet);
            this.storeTruncateDataset(dataSourceName, connection.getSchema(), truncateDataSet);
            log.debug("Sorted dataset generated");
        }
        if (truncateDataSet != null) {
            if (log.isDebugEnabled()) {
                log.debug("Tables truncateDataSet: {}", (Object)ArrayUtils.toString((Object)truncateDataSet.getTableNames()));
            }
            databaseOperation.execute(connection, truncateDataSet);
        }
    }

    private IDataSet getTruncateDataset(String datasourceName, String schema) {
        return truncateDataSetCache.get(datasourceName + "_" + StringUtils.defaultString((String)schema));
    }

    private IDataSet storeTruncateDataset(String datasourceName, String schema, IDataSet dataset) {
        return truncateDataSetCache.put(datasourceName + "_" + StringUtils.defaultString((String)schema), dataset);
    }

    protected DataSource getDatasource(String name) {
        if (StringUtils.isEmpty((String)name)) {
            Map dsMap = this.applicationContext.getBeansOfType(DataSource.class);
            if (dsMap == null || dsMap.size() != 1) {
                throw new RuntimeException("Unable to find a datasource in spring applicationContext, please specify the datasource bean name using the \"datasource\" attribute of @DbUnitConfiguration");
            }
            return (DataSource)dsMap.values().iterator().next();
        }
        return (DataSource)this.applicationContext.getBean(name);
    }
}

