/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing.dbunit;

import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.operation.DatabaseOperation;


/**
 * Extends the standard org.dbunit.ext.mssql.InsertIdentityOperation in order to be able to use this class directly in a
 * annotation. Wraps a <code>DatabaseOperation.CLEAN_INSERT</code> operation.
 * @see org.dbunit.ext.mssql.InsertIdentityOperation
 * @author fgiust
 * @version $Id: MsSqlIndentityCleanInsertOperation.java 578 2008-01-31 13:13:40Z fgiust $
 */
public class MsSqlIndentityCleanInsertOperation extends InsertIdentityOperation
{

    /**
     * @param operation
     */
    public MsSqlIndentityCleanInsertOperation()
    {
        super(DatabaseOperation.CLEAN_INSERT);
    }

}
