/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing.dbunit;

import org.dbunit.operation.CompositeOperation;
import org.dbunit.operation.DatabaseOperation;


/**
 * Mimics the standard <code>DatabaseOperation.CLEAN_INSERT</code> operation with an empty constructor (can be used in
 * annotations).
 * @author fgiust
 * @version $Id: CleanInsertOperation.java 578 2008-01-31 13:13:40Z fgiust $
 */
public class CleanInsertOperation extends CompositeOperation
{

    /**
     * @param action1
     * @param action2
     */
    public CleanInsertOperation()
    {
        super(DatabaseOperation.DELETE_ALL, DatabaseOperation.INSERT);
    }

}
