/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;


/**
 * @author fgiust
 * @version $Id: TestUtils.java 529 2008-01-20 08:58:09Z fgiust $
 */
public final class TestUtils
{

    private TestUtils()
    {
    }

    /**
     * Create a new set with all the elements.
     * @param <T> the type of the elements. Also used to allocate the set.
     * @param elements to put in the set.
     * @return new allocated set.
     */
    public static <T> Set<T> setWith(T... elements)
    {
        Set<T> newSet = new HashSet<T>(elements.length);
        for (T element : elements)
        {
            newSet.add(element);
        }
        return newSet;
    }

    /**
     * Create a new list with all the elements.
     * @param <T> the type of the elements. Also used to allocate the list.
     * @param elements to put in the list.
     * @return new allocated list.
     */
    public static <T> List<T> listWith(T... elements)
    {
        List<T> newList = new ArrayList<T>(elements.length);
        for (T element : elements)
        {
            newList.add(element);
        }
        return newList;
    }
}
