/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing;

import java.util.regex.Pattern;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.filter.AbstractTableFilter;


/**
 * A table filter that excludes tables mathing the given regexp.
 * @author fgiust
 * @version $Id: RegExpTableFilter.java 581 2008-01-31 22:19:56Z fgiust $
 */
public class RegExpTableFilter extends AbstractTableFilter
{

    private Pattern pattern;

    /**
     * Instantiates a new RegExpTableFilter
     * @param pattern regexp pattern
     */
    public RegExpTableFilter(String pattern)
    {
        if (pattern != null)
        {
            this.pattern = Pattern.compile(pattern);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isValidName(String tableName) throws DataSetException
    {
        return pattern == null || !pattern.matcher(tableName).matches();
    }

}
