/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.dbunit.operation.DatabaseOperation;


/**
 * @author fgiust
 * @version $Id: DbUnitExecution.java 581 2008-01-31 22:19:56Z fgiust $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
@Documented
public @interface DbUnitExecution {

    /**
     * The resource locations to use for loading dbunit dataset.
     */
    String[] datasets() default {

    };

    /**
     * The name of the datasource to use. If can be left unset only if there is only one DataSource available in the
     * Spring context.
     */
    String dataSource() default "";

    /**
     * Db schema name that will be given to dbUnit. Can be left unset if not needed (database specific)
     */
    String schema() default "";

    /**
     * A regexp that can match table names. Any table matching this regular expression will not be considered by DbUnit.
     * By default tables starting with $ are ignored (oracle recycle bin).
     */
    String excludedTables() default "(^\\$(.*))"; // oracle recycle bin

    /**
     * If true, <strong>all</strong> the tables in the database will be truncated before loading any dataset.
     */
    boolean truncateAll() default true;

    /**
     * The database operation that will be used to truncate tables. Defaults to org.dbunit.operation.DeleteAllOperation
     */
    Class< ? extends DatabaseOperation> truncateOperation() default org.dbunit.operation.DeleteAllOperation.class;

    /**
     * The database operation that will be used to load datasets. Defaults to org.dbunit.operation.InsertOperation
     */
    Class< ? extends DatabaseOperation> insertOperation() default org.dbunit.operation.InsertOperation.class;

}