/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.web.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamNameUrlHandlerMapping
extends AbstractUrlHandlerMapping {
    private static Logger log = LoggerFactory.getLogger(ParamNameUrlHandlerMapping.class);
    private final Map<String, String> urlMap = new HashMap<String, String>();
    private String paramName;

    public void setUrlMap(Map<String, String> urlMap) {
        this.urlMap.putAll(urlMap);
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setMappings(Properties mappings) {
        this.urlMap.putAll(mappings);
    }

    public void initApplicationContext() throws BeansException {
        if (this.paramName == null) {
            this.logger.error((Object)"'paramName' not specified for ParamNameUrlHandlerMapping");
        }
        if (this.urlMap.isEmpty()) {
            this.logger.info((Object)"Neither 'urlMap' nor 'mappings' set on ParamNameUrlHandlerMapping");
        } else {
            for (String url : this.urlMap.keySet()) {
                String handler = this.urlMap.get(url);
                this.registerHandler(url, handler);
            }
        }
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        String lookupPath = request.getParameter(this.paramName);
        if (lookupPath == null) {
            lookupPath = (String)request.getAttribute(this.paramName);
        }
        if (lookupPath == null) {
            log.debug("No parameter found in request for [{}]", (Object)this.paramName);
            return null;
        }
        Object handler = this.lookupHandler(lookupPath, request);
        log.debug("Returning handler [{}] for action [{}]", handler, (Object)lookupPath);
        return handler;
    }
}

