/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.web.spring;

import it.openutils.web.util.MessageUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

public abstract class MultiController
extends MultiActionController
implements Controller {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected String successView;

    public void setSuccessView(String successView) {
        this.successView = successView;
    }

    public String getText(String msgKey) {
        return this.getMessageSourceAccessor().getMessage(msgKey);
    }

    public String getText(String msgKey, Object arg) {
        return this.getText(msgKey, new Object[]{arg});
    }

    public String getText(String msgKey, Object[] args) {
        return this.getMessageSourceAccessor().getMessage(msgKey, args);
    }

    public void saveMessage(HttpServletRequest request, String message) {
        MessageUtils.saveMessage(request, message);
    }

    public void saveError(HttpServletRequest request, String message) {
        MessageUtils.saveError(request, message);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.debug("handleRequestInternal");
        try {
            String methodName = this.getMethodNameResolver().getHandlerMethodName(request);
            this.log.debug("methodName is " + methodName);
            return this.invokeNamedMethod(methodName, request, response);
        }
        catch (NoSuchRequestHandlingMethodException ex) {
            pageNotFoundLogger.warn((Object)ex.getMessage());
            response.sendError(404);
            return null;
        }
    }

    public String toString() {
        return ClassUtils.getShortClassName(((Object)((Object)this)).getClass());
    }
}

