/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.web.spring;

import it.openutils.web.spring.EasyDoubleCustomEditor;
import it.openutils.web.util.MessageUtils;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class BaseFormController
extends SimpleFormController {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, null, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true, 10));
        binder.registerCustomEditor(Long.class, null, (PropertyEditor)new CustomNumberEditor(Long.class, true));
        binder.registerCustomEditor(Double.class, null, (PropertyEditor)((Object)new EasyDoubleCustomEditor(Double.class, true)));
        binder.registerCustomEditor(Integer.class, null, (PropertyEditor)new CustomNumberEditor(Integer.class, true));
        binder.registerCustomEditor(Short.class, null, (PropertyEditor)new CustomNumberEditor(Short.class, true));
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
    }

    public String getText(String msgKey, Object arg) {
        return this.getText(msgKey, new Object[]{arg});
    }

    public void saveMessage(HttpServletRequest request, String message) {
        MessageUtils.saveMessage(request, message);
    }

    public void saveError(HttpServletRequest request, String message) {
        MessageUtils.saveError(request, message);
    }

    public String toString() {
        return ClassUtils.getShortClassName(((Object)((Object)this)).getClass());
    }
}

