/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.spring.validation.hibernate;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class AnnotationValidator
implements Validator,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public void validate(Object obj, Errors errors) {
        InvalidValue[] validationMessages;
        ClassValidator classValidator = new ClassValidator(obj.getClass(), (ResourceBundle)new KeybackResourceBundle());
        for (InvalidValue value : validationMessages = classValidator.getInvalidValues(obj)) {
            String field = value.getPropertyPath();
            String[] codes = new String[]{errors.getObjectName() + "." + field, field};
            errors.rejectValue(field, value.getMessage(), new Object[]{new DefaultMessageSourceResolvable(codes, field)}, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class KeybackResourceBundle
    extends ResourceBundle {
        protected KeybackResourceBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return new Hashtable().keys();
        }

        @Override
        protected Object handleGetObject(String key) {
            return key;
        }
    }
}

