/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.spring.editors;

import java.beans.PropertyEditorSupport;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSinglePropertyEditor<T>
extends PropertyEditorSupport {
    private static Logger log = LoggerFactory.getLogger(GenericSinglePropertyEditor.class);
    private Object dao;
    private String propertyName;
    private Class<T> propertyType;

    public GenericSinglePropertyEditor(Object dao, String propertyName, Class<T> propertyType) {
        this.dao = dao;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        log.debug("getAsText({})", value);
        String returnString = null;
        if (value != null) {
            try {
                returnString = BeanUtils.getProperty((Object)value, (String)this.propertyName);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return StringUtils.defaultString(returnString);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        log.debug("setAsText({})", (Object)text);
        if (StringUtils.isNotBlank((String)text)) {
            try {
                Object[] parameters = new Object[1];
                if (Integer.class.equals(this.propertyType)) {
                    parameters[0] = new Integer(text);
                }
                if (String.class.equals(this.propertyType)) {
                    parameters[0] = text;
                }
                if (Long.class.equals(this.propertyType)) {
                    parameters[0] = new Long(text);
                }
                Object value = MethodUtils.invokeMethod((Object)this.dao, (String)"load", (Object[])parameters, (Class[])new Class[]{this.propertyType});
                this.setValue(value);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
    }
}

