/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.spring.editors;

import java.beans.PropertyEditorSupport;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSetPropertyEditor<T>
extends PropertyEditorSupport {
    private static Logger log = LoggerFactory.getLogger(GenericSetPropertyEditor.class);
    private Object dao;
    private String propertyName;
    private Class<T> propertyType;

    public GenericSetPropertyEditor(Object dao, String propertyName, Class<T> propertyType) {
        this.dao = dao;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    @Override
    public String getAsText() {
        Set value = (Set)this.getValue();
        log.debug("getAsText({})", (Object)value);
        if (value != null && value.size() > 0) {
            try {
                StringBuffer buffer = new StringBuffer();
                Iterator iterator = value.iterator();
                while (iterator.hasNext()) {
                    Object item = iterator.next();
                    buffer.append(BeanUtils.getProperty(item, (String)this.propertyName));
                    if (!iterator.hasNext()) continue;
                    buffer.append(",");
                }
                return buffer.toString();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        log.debug("setAsText({})", (Object)text);
        if (StringUtils.isNotEmpty((String)text)) {
            HashSet<Object> set = new HashSet<Object>();
            String[] values = StringUtils.split((String)text, (char)',');
            for (int j = 0; j < values.length; ++j) {
                String id = values[j];
                if (!StringUtils.isNotEmpty((String)id)) continue;
                try {
                    Object[] parameters = new Object[1];
                    if (Integer.class.equals(this.propertyType)) {
                        parameters[0] = new Integer(id);
                    }
                    if (String.class.equals(this.propertyType)) {
                        parameters[0] = id;
                    }
                    if (Long.class.equals(this.propertyType)) {
                        parameters[0] = new Long(id);
                    }
                    Object value = MethodUtils.invokeMethod((Object)this.dao, (String)"load", (Object[])parameters, (Class[])new Class[]{this.propertyType});
                    set.add(value);
                    continue;
                }
                catch (Throwable e) {
                    log.error("Not adding object with id [" + id + "] due to a " + e.getClass().getName(), e);
                }
            }
            this.setValue(set);
        }
    }
}

